/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.google.common.collect.ImmutableBiMap;
import ksp.com.google.common.collect.ImmutableSet;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKt;
import ksp.org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirExpressionRef;
import ksp.org.jetbrains.kotlin.fir.FirFunctionTarget;
import ksp.org.jetbrains.kotlin.fir.FirModuleData;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.builder.AbstractRawFirBuilder;
import ksp.org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import ksp.org.jetbrains.kotlin.fir.builder.Context;
import ksp.org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirReceiverParameterBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBooleanOperatorExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import ksp.org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLazyBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirBooleanOperatorExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import ksp.org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import ksp.org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import ksp.org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirThisOwnerSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import ksp.org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import ksp.org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import ksp.org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImplWithoutSource;
import ksp.org.jetbrains.kotlin.lexer.KtSingleValueToken;
import ksp.org.jetbrains.kotlin.lexer.KtToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.types.ConstantValueKind;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.expressions.OperatorConventions;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00e0\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u000e\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u000e\u001a\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a$\u0010\u001c\u001a\u00020\u001d*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a.\u0010 \u001a\u00020!*\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001b\u001a.\u0010%\u001a\u00020&*\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001b\u001a0\u0010(\u001a\u00020!*\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\rH\u0002\u001a\"\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u001b2\b\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020\r\u001a\u0018\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u001b2\u0006\u00102\u001a\u000203\u001a\u001c\u00104\u001a\u000205*\u0002032\b\u00106\u001a\u0004\u0018\u00010\u001b2\u0006\u00107\u001a\u000208\u001a\u00a4\u0001\u0010?\u001a\u00020@\"\u0004\b\u0000\u0010A*\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020F2\f\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010:2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HA0H2\u0006\u0010I\u001a\u00020\u001f2\n\b\u0002\u0010J\u001a\u0004\u0018\u00010K2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M28\b\u0002\u0010N\u001a2\u0012\u0013\u0012\u00110P\u00a2\u0006\f\bQ\u0012\b\b.\u0012\u0004\b\b(R\u0012\u0013\u0012\u00110S\u00a2\u0006\f\bQ\u0012\b\b.\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020@0O2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010\u001b\u001a\u001a\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[\u001a\u0016\u0010\\\u001a\u00020]*\u00020!2\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010[\u001a\n\u0010^\u001a\u00020\u001f*\u00020Y\u001a\u001b\u0010_\u001a\u00020\u001f*\u00020`\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\u0016\u0010a\u001a\u00020\u001f*\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001a\u0010b\u001a\u00020c*\u0002002\u0006\u0010d\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001b\u001a\n\u0010e\u001a\u00020\u0018*\u000200\u001aS\u0010e\u001a\u00020\u0018\"\b\b\u0000\u0010f*\u00020\u0018*\u0002Hf2\u0019\u0010g\u001a\u0015\u0012\u0004\u0012\u0002Hf\u0012\u0006\u0012\u0004\u0018\u00010\u00180h\u00a2\u0006\u0002\bi2\u001d\u0010j\u001a\u0019\u0012\u0004\u0012\u0002Hf\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020@0O\u00a2\u0006\u0002\bi\u00a2\u0006\u0002\u0010k\u001a\n\u0010l\u001a\u00020\u001f*\u00020`\u001a\n\u0010l\u001a\u00020\u001f*\u00020\u001b\u001a\u001e\u0010m\u001a\b\u0012\u0004\u0012\u00020o0n*\b\u0012\u0004\u0012\u00020o0n2\u0006\u0010R\u001a\u00020p\u001a0\u0010q\u001a\u00020r*\u0006\u0012\u0002\b\u00030s2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020v0u2\u0006\u0010E\u001a\u00020F2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030x\u001a\u001e\u0010y\u001a\u00020r*\u00020\u001b2\u0006\u0010E\u001a\u00020F2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030x\u001a\u001e\u0010z\u001a\u00020@\"\u0004\b\u0000\u0010A*\u00020{2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HA0H\u001a\u001c\u0010|\u001a\u0004\u0018\u00010}\"\u0004\b\u0000\u0010A2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HA0H\u001a,\u0010\u0081\u0001\u001a\u00020\u00182\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180n2\t\b\u0002\u0010\u0083\u0001\u001a\u0002082\t\b\u0002\u0010\u0084\u0001\u001a\u000208\u001a\u0016\u0010\u0085\u0001\u001a\u00020\u0018*\u00020\u00182\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0018\u001a\r\u0010\u0087\u0001\u001a\u00020\u001f*\u0004\u0018\u00010p\u001a\r\u0010\u0088\u0001\u001a\u00030\u0089\u0001*\u00030\u008a\u0001\u001a+\u0010\u008b\u0001\u001a\u00020\u001f2\u0007\u0010\u008c\u0001\u001a\u00020\u001f2\u0007\u0010\u008d\u0001\u001a\u00020\u001f2\u0007\u0010\u008e\u0001\u001a\u00020\u001f2\u0007\u0010\u008f\u0001\u001a\u00020\u001f\"*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\tj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\":\u0010\u0013\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\u0004\u0012\u00020\u00110\tj\u0016\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\u0004\u0012\u00020\u0011`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u00109\u001a\b\u0012\u0004\u0012\u00020;0:*\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0016\u0010~\u001a\u00020\u001f*\u00020\u007f8F\u00a2\u0006\u0007\u001a\u0005\b~\u0010\u0080\u0001\u00f2\u0001\u0004\n\u00020!\u00a8\u0006\u0090\u0001"}, d2={"parseCharacter", "Lksp/org/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "", "escapedStringToCharacter", "text", "translateEscape", "c", "", "escapeCharToChartedWithDiagnosticMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "illegalEscapeDiagnostic", "toBinaryName", "Lksp/org/jetbrains/kotlin/name/Name;", "Lksp/com/intellij/psi/tree/IElementType;", "toUnaryName", "toFirOperation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirOperationOrNull", "ktTokenToFirOperationMap", "Lksp/org/jetbrains/kotlin/lexer/KtToken;", "kotlin.jvm.PlatformType", "generateNotNullOrOther", "Lksp/org/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "other", "baseSource", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "generateLazyLogicalOperation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBooleanOperatorExpression;", "isAnd", "", "generateContainsOperation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "argument", "inverted", "operationReferenceSource", "generateComparisonExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "createConventionCall", "conventionName", "generateAccessExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "qualifiedSource", "calleeReferenceSource", "name", "generateResolvedAccessExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "source", "variable", "Lksp/org/jetbrains/kotlin/fir/declarations/FirVariable;", "toComponentCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirComponentCall;", "entrySource", "index", "", "ownerRegularOrAnonymousObjectSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "generateAccessorsByDelegate", "", "T", "Lksp/org/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lksp/org/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "moduleData", "Lksp/org/jetbrains/kotlin/fir/FirModuleData;", "context", "Lksp/org/jetbrains/kotlin/fir/builder/Context;", "isExtension", "lazyDelegateExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirLazyExpression;", "lazyBodyForGeneratedAccessors", "Lksp/org/jetbrains/kotlin/fir/expressions/FirLazyBlock;", "bindFunction", "Lkotlin/Function2;", "Lksp/org/jetbrains/kotlin/fir/FirFunctionTarget;", "Lkotlin/ParameterName;", "target", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "explicitDeclarationSource", "processLegacyContractDescription", "Lksp/org/jetbrains/kotlin/fir/contracts/FirContractDescription;", "block", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "diagnostic", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "toLegacyRawContractDescription", "Lksp/org/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "isContractPresentFirCheck", "isContractBlockFirCheck", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "checkReceiver", "createSafeCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "receiver", "pullUpSafeCallIfNecessary", "F", "obtainReceiver", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "replaceReceiver", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isChildInParentheses", "filterUseSiteTarget", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lksp/org/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "createReceiverParameter", "Lksp/org/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "Lksp/org/jetbrains/kotlin/fir/builder/AbstractRawFirBuilder;", "typeRefCalculator", "Lkotlin/Function0;", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "containingCallableSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "asReceiverParameter", "initContainingClassAttr", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "currentDispatchReceiverType", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isUnderscore", "", "(Ljava/lang/CharSequence;)Z", "buildBalancedOrExpressionTree", "conditions", "lower", "upper", "guardedBy", "guard", "appliesToPrimaryConstructorParameter", "wrapIntoArray", "Lksp/org/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lksp/org/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "shouldGenerateDelegatedSuperCall", "isAnySuperCall", "isExpectClass", "isEnumEntry", "hasExplicitDelegatedCalls", "raw-fir.common"})
@SourceDebugExtension(value={"SMAP\nConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n+ 2 FirElvisExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElvisExpressionBuilderKt\n+ 3 FirBooleanOperatorExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBooleanOperatorExpressionBuilderKt\n+ 4 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 5 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 6 FirComparisonExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComparisonExpressionBuilderKt\n+ 7 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 8 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 9 FirComponentCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComponentCallBuilderKt\n+ 10 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 11 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 12 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 13 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 14 FirLegacyRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirLegacyRawContractDescriptionBuilderKt\n+ 15 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 16 FirCheckedSafeCallSubjectBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckedSafeCallSubjectBuilderKt\n+ 17 FirSafeCallExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSafeCallExpressionBuilderKt\n+ 18 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 19 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 20 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 21 FirReceiverParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirReceiverParameterBuilderKt\n+ 22 AbstractRawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/AbstractRawFirBuilder\n+ 23 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 24 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 25 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 26 FirImplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirImplicitThisReferenceBuilderKt\n+ 27 FirDelegateFieldReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirDelegateFieldReferenceBuilderKt\n+ 28 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 29 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n*L\n1#1,784:1\n53#2:785\n52#3:786\n66#4:787\n66#4:790\n66#4:797\n66#4:801\n66#4:806\n41#5:788\n41#5:791\n41#5:793\n41#5:798\n41#5:802\n41#5:807\n55#6:789\n65#7:792\n65#7:794\n65#7:809\n65#7:872\n42#8:795\n42#8:810\n42#8:875\n61#9:796\n89#10:799\n89#10:803\n56#11:800\n56#11:805\n75#12:804\n39#13:808\n39#13:814\n42#14:811\n46#15:812\n46#15:815\n48#16:813\n50#17:816\n1617#18,9:817\n1869#18:826\n1870#18:839\n1626#18:840\n827#18:857\n855#18,2:858\n1634#18,2:876\n1636#18:880\n80#19,11:827\n1#20:838\n59#21:841\n59#21:864\n168#22,15:842\n184#22,4:860\n1069#23,2:865\n49#24:867\n49#24:879\n81#25:868\n81#25:870\n39#26:869\n39#26:871\n39#27:873\n64#28:874\n42#29:878\n*S KotlinDebug\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n*L\n177#1:785\n187#1:786\n208#1:787\n257#1:790\n419#1:797\n452#1:801\n510#1:806\n210#1:788\n259#1:791\n275#1:793\n421#1:798\n455#1:802\n513#1:807\n244#1:789\n273#1:792\n285#1:794\n520#1:809\n364#1:872\n287#1:795\n522#1:810\n378#1:875\n298#1:796\n440#1:799\n482#1:803\n451#1:800\n509#1:805\n492#1:804\n517#1:808\n607#1:814\n556#1:811\n574#1:812\n609#1:815\n595#1:813\n615#1:816\n659#1:817,9\n659#1:826\n659#1:839\n659#1:840\n678#1:857\n678#1:858,2\n406#1:876,2\n406#1:880\n661#1:827,11\n659#1:838\n670#1:841\n693#1:864\n672#1:842,15\n672#1:860,4\n711#1:865,2\n759#1:867\n410#1:879\n348#1:868\n354#1:870\n350#1:869\n356#1:871\n366#1:873\n376#1:874\n407#1:878\n*E\n"})
public final class ConversionUtilsKt {
    @NotNull
    private static final HashMap<Character, CharacterWithDiagnostic> escapeCharToChartedWithDiagnosticMap;
    @NotNull
    private static final CharacterWithDiagnostic illegalEscapeDiagnostic;
    @NotNull
    private static final HashMap<KtToken, FirOperation> ktTokenToFirOperationMap;

    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        if (((CharSequence)text).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text.charAt(0) != '\\' ? (text.length() == 1 ? new CharacterWithDiagnostic(text.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl3 = bl2 = ((CharSequence)text).length() > 0 && text.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Only escaped sequences must be passed to this routine: " + text;
            throw new AssertionError((Object)string);
        }
        String string = text.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String escape = string;
        switch (escape.length()) {
            case 0: {
                return illegalEscapeDiagnostic;
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string2 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Integer intValue = StringsKt.toIntOrNull((String)string2, (int)16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return illegalEscapeDiagnostic;
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c2) {
        CharacterWithDiagnostic characterWithDiagnostic = escapeCharToChartedWithDiagnosticMap.get(Character.valueOf(c2));
        if (characterWithDiagnostic == null) {
            characterWithDiagnostic = illegalEscapeDiagnostic;
        }
        return characterWithDiagnostic;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"BINARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"UNARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        FirOperation firOperation = ConversionUtilsKt.toFirOperationOrNull($this$toFirOperation);
        if (firOperation == null) {
            throw new IllegalStateException(("Cannot convert element type to FIR operation: " + $this$toFirOperation).toString());
        }
        return firOperation;
    }

    @Nullable
    public static final FirOperation toFirOperationOrNull(@NotNull IElementType $this$toFirOperationOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperationOrNull, (String)"<this>");
        return (FirOperation)((Object)((Map)ktTokenToFirOperationMap).get($this$toFirOperationOrNull));
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable KtSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u241 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl2 = false;
        $this$generateNotNullOrOther_u24lambda_u241.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u241.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u241.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBooleanOperatorExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable KtSourceElement baseSource) {
        FirBooleanOperatorExpressionBuilder firBooleanOperatorExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBooleanOperatorExpression = false;
        FirBooleanOperatorExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u242 = firBooleanOperatorExpressionBuilder = new FirBooleanOperatorExpressionBuilder();
        boolean bl2 = false;
        $this$generateLazyLogicalOperation_u24lambda_u242.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u242.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u242.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u242.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBooleanOperatorExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument, boolean inverted, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u244_u24lambda_u243;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        KtSourceElement ktSourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        if (inverted) {
            KtSourceElement ktSourceElement2 = operationReferenceSource;
            ktSourceElement = ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null;
        } else {
            ktSourceElement = operationReferenceSource;
        }
        KtSourceElement resultReferenceSource = ktSourceElement;
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, resultReferenceSource, baseSource, argument, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u244 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        KtSourceElement ktSourceElement3 = baseSource;
        $this$generateContainsOperation_u24lambda_u244.setSource(ktSourceElement3 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement3, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE, 0, 0, 6, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u244;
        boolean bl3 = false;
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setSource(resultReferenceSource);
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setName(OperatorNameConventions.NOT);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u244.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u244.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument, @NotNull IElementType operatorToken, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"COMPARISON_OPERATIONS");
        if (!CollectionsKt.contains((Iterable)immutableSet, (Object)operatorToken)) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        KtSourceElement ktSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE, 0, 0, 6, null) : null, argument, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(("Unknown " + operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u246 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl2 = false;
        $this$generateComparisonExpression_u24lambda_u246.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u246.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u246.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, KtSourceElement operationReferenceSource, KtSourceElement baseSource, FirExpression argument, Name conventionName) {
        void $this$createConventionCall_u24lambda_u248_u24lambda_u247;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u248 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u248.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u248;
        boolean bl3 = false;
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setName(conventionName);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u248.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u248.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument));
        $this$createConventionCall_u24lambda_u248.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirPropertyAccessExpression generateAccessExpression(@Nullable KtSourceElement qualifiedSource, @Nullable KtSourceElement calleeReferenceSource, @NotNull Name name2) {
        void $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249;
        KtSourceElement ktSourceElement;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2410 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl2 = false;
        $this$generateAccessExpression_u24lambda_u2410.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2410;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)calleeReferenceSource, (Object)qualifiedSource)) {
            KtSourceElement ktSourceElement2 = calleeReferenceSource;
            ktSourceElement = ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE, 0, 0, 6, null) : null;
        } else {
            ktSourceElement = calleeReferenceSource;
        }
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setSource(ktSourceElement);
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setName(name2);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable KtSourceElement source, @NotNull FirVariable variable) {
        void $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2412 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2412;
        boolean bl3 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setName(variable.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setResolvedSymbol((FirBasedSymbol)variable.getSymbol());
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    @NotNull
    public static final FirComponentCall toComponentCall(@NotNull FirVariable $this$toComponentCall, @Nullable KtSourceElement entrySource, int index2) {
        FirComponentCallBuilder firComponentCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toComponentCall, (String)"<this>");
        boolean $i$f$buildComponentCall = false;
        FirComponentCallBuilder $this$toComponentCall_u24lambda_u2413 = firComponentCallBuilder = new FirComponentCallBuilder();
        boolean bl2 = false;
        KtSourceElement ktSourceElement = entrySource;
        KtSourceElement componentCallSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE, 0, 0, 6, null) : null;
        $this$toComponentCall_u24lambda_u2413.setSource(componentCallSource);
        $this$toComponentCall_u24lambda_u2413.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(componentCallSource, $this$toComponentCall));
        $this$toComponentCall_u24lambda_u2413.setComponentIndex(index2 + 1);
        return firComponentCallBuilder.build();
    }

    @NotNull
    public static final FirClassSymbol<FirClass> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        FirClassSymbol firClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularOrAnonymousObjectSymbol, (String)"<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        if (firClassBuilder instanceof FirAnonymousObjectBuilder) {
            firClassSymbol = ((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol();
        } else if (firClassBuilder instanceof FirRegularClassBuilder) {
            firClassSymbol = ((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firClassSymbol;
    }

    /*
     * Unable to fully structure code
     */
    public static final <T> void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @NotNull Context<T> context, boolean isExtension, @Nullable FirLazyExpression lazyDelegateExpression, @Nullable FirLazyBlock lazyBodyForGeneratedAccessors, @NotNull Function2<? super FirFunctionTarget, ? super FirFunction, Unit> bindFunction, @Nullable KtSourceElement explicitDeclarationSource) {
        block17: {
            Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter(bindFunction, (String)"bindFunction");
            if (delegateBuilder == null) {
                return;
            }
            it = var11_10 = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$1 = false;
            $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
            delegateFieldSymbol = var11_10;
            isMember = ownerRegularOrAnonymousObjectSymbol != null;
            v0 = delegateBuilder.getSource();
            fakeSource = v0 != null ? KtSourceElementKt.fakeElement$default(v0, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null) : null;
            v1 = explicitDeclarationSource;
            if (v1 == null || (v1 = KtSourceElementKt.fakeElement$default(v1, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                v1 = fakeSource;
            }
            declarationFakeSource = v1;
            isVar = $this$generateAccessorsByDelegate.isVar();
            v2 = $this$generateAccessorsByDelegate;
            v3 = lazyDelegateExpression;
            if (v3 != null) {
                v4 = v3;
            } else {
                var16_17 = $this$generateAccessorsByDelegate;
                var52_18 = v2;
                $i$a$-run-ConversionUtilsKt$generateAccessorsByDelegate$2 = false;
                $i$f$buildFunctionCall = false;
                var19_25 = new FirFunctionCallBuilder();
                var20_27 = var19_25;
                var21_30 = delegateBuilder;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setExplicitReceiver(delegateBuilder.getExpression());
                $i$f$buildSimpleNamedReference = false;
                var25_42 = var24_40 = new FirSimpleNamedReferenceBuilder();
                var26_44 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setName(OperatorNameConventions.PROVIDE_DELEGATE);
                var26_44.setCalleeReference(var24_40.build());
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setOrigin(FirFunctionCallOrigin.Operator);
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.setSource(fakeSource);
                var21_30.setProvideDelegateCall(var19_25.build());
                v2 = var52_18;
                v4 = delegateBuilder.build();
            }
            v2.setDelegate(v4);
            if ($this$generateAccessorsByDelegate.getGetter() != null && !($this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor)) break block17;
            v5 = $this$generateAccessorsByDelegate.getGetter();
            annotations = v5 != null ? v5.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            v6 = $this$generateAccessorsByDelegate.getGetter();
            getterStatus = v6 != null ? v6.getStatus() : null;
            var19_25 = $this$generateAccessorsByDelegate.getGetter();
            if (var19_25 == null || ($this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = var19_25.getSource()) == null) ** GOTO lbl-1000
            it = $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427;
            $i$a$-takeIf-ConversionUtilsKt$generateAccessorsByDelegate$getterElement$1 = false;
            v7 = var21_30 = Intrinsics.areEqual((Object)it.getKind(), (Object)KtRealSourceElementKind.INSTANCE) != false ? $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 : null;
            if (var21_30 != null && ($i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1 = KtSourceElementKt.fakeElement$default((KtSourceElement)var21_30, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) != null) {
                v8 = $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$2$1;
            } else lbl-1000:
            // 2 sources

            {
                v8 = declarationFakeSource;
            }
            getterElement = v8;
            $i$f$buildPropertyAccessor = false;
            var21_30 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = new FirPropertyAccessorBuilder();
            var52_18 = $this$generateAccessorsByDelegate;
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$3 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2434.setSource(getterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setGetter(true);
            v9 = getterStatus;
            if (v9 == null || (v9 = v9.getVisibility()) == null) {
                v9 = Visibilities.Unknown.INSTANCE;
            }
            $i$a$-takeIf-ConversionUtilsKt$generateAccessorsByDelegate$getterElement$1 = it = new FirDeclarationStatusImpl((Visibility)v9, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2434;
            $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$3$1 = false;
            v10 = getterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.setInline(v10 != null ? v10.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.isInline());
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setStatus(it);
            $this$generateAccessorsByDelegate_u24lambda_u2434.setSymbol(new FirPropertyAccessorSymbol());
            v11 = $this$generateAccessorsByDelegate_u24lambda_u2434;
            v12 = lazyBodyForGeneratedAccessors;
            if (v12 != null) {
                v13 = v12;
            } else {
                $i$f$buildReturnExpression = false;
                $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$3$1 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430 = new FirReturnExpressionBuilder();
                $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = v11;
                $i$a$-buildReturnExpression-ConversionUtilsKt$generateAccessorsByDelegate$3$2 = false;
                $i$f$buildFunctionCall = false;
                var32_53 = var31_52 = new FirFunctionCallBuilder();
                var33_55 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context));
                $i$f$buildSimpleNamedReference = false;
                var37_62 = var36_60 = new FirSimpleNamedReferenceBuilder();
                var38_64 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setName(OperatorNameConventions.GET_VALUE);
                var38_64.setCalleeReference(var36_60.build());
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setOrigin(FirFunctionCallOrigin.Operator);
                var33_55.setResult(var31_52.build());
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433.setTarget(returnTarget);
                $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2433.setSource(fakeSource);
                v11 = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
                var53_67 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430.build();
                v13 = new FirSingleExpressionBlock(var53_67);
            }
            v11.setBody(v13);
            if (annotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2434.getAnnotations().addAll((Collection<FirAnnotation>)annotations);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2434.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            $i$f$buildPropertyAccessor = $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427.build();
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427 = $i$f$buildPropertyAccessor;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = false;
            bindFunction.invoke((Object)returnTarget, (Object)it);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context);
            var52_18.setGetter($i$f$buildPropertyAccessor);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            v14 = $this$generateAccessorsByDelegate.getSetter();
            annotations = v14 != null ? v14.getAnnotations() : null;
            returnTarget = new FirFunctionTarget(null, false);
            v15 = $this$generateAccessorsByDelegate.getSetter();
            parameterAnnotations = v15 != null && (v15 = v15.getValueParameters()) != null && (v15 = (FirValueParameter)CollectionsKt.firstOrNull((List)v15)) != null ? v15.getAnnotations() : null;
            v16 = $this$generateAccessorsByDelegate.getSetter();
            setterStatus = v16 != null ? v16.getStatus() : null;
            v17 = $this$generateAccessorsByDelegate.getSetter();
            if (v17 == null || (v17 = v17.getSource()) == null || (v17 = KtSourceElementKt.fakeElement$default((KtSourceElement)v17, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                v17 = declarationFakeSource;
            }
            setterElement = v17;
            $i$f$buildPropertyAccessor = false;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = new FirPropertyAccessorBuilder();
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$3 = $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4;
            var52_18 = $this$generateAccessorsByDelegate;
            $i$a$-buildPropertyAccessor-ConversionUtilsKt$generateAccessorsByDelegate$5 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2444.setSource((KtSourceElement)setterElement);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2444.setGetter(false);
            v18 = setterStatus;
            if (v18 == null || (v18 = v18.getVisibility()) == null) {
                v18 = Visibilities.Unknown.INSTANCE;
            }
            $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430 = new FirDeclarationStatusImpl((Visibility)v18, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426 = $this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430;
            var26_44 = $this$generateAccessorsByDelegate_u24lambda_u2444;
            $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$5$1 = false;
            v19 = setterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2436.setInline(v19 != null ? v19.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2436.isInline());
            var26_44.setStatus((FirDeclarationStatus)$this$generateAccessorsByDelegate_u24lambda_u2434_u24lambda_u2430);
            $this$generateAccessorsByDelegate_u24lambda_u2444.setSymbol(new FirPropertyAccessorSymbol());
            $i$f$buildValueParameter = false;
            var27_48 = new FirValueParameterBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437 = var27_48;
            $i$a$-buildValueParameter-ConversionUtilsKt$generateAccessorsByDelegate$5$parameter$1 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setSource(declarationFakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setContainingDeclarationSymbol($this$generateAccessorsByDelegate_u24lambda_u2444.getSymbol());
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setReturnTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.setVararg(false);
            if (parameterAnnotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437.getAnnotations().addAll((Collection<FirAnnotation>)parameterAnnotations);
            }
            parameter = var27_48.build();
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444.getValueParameters()).add(parameter);
            v20 = $this$generateAccessorsByDelegate_u24lambda_u2444;
            v21 = lazyBodyForGeneratedAccessors;
            if (v21 != null) {
                v22 = v21;
            } else {
                $i$f$buildReturnExpression = false;
                var27_48 = new FirReturnExpressionBuilder();
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2437 = var27_48;
                var26_44 = v20;
                $i$a$-buildReturnExpression-ConversionUtilsKt$generateAccessorsByDelegate$5$2 = false;
                $i$f$buildFunctionCall = false;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1 = var33_55 = new FirFunctionCallBuilder();
                var35_59 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443;
                $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, context));
                $i$f$buildSimpleNamedReference = false;
                var38_64 = new FirSimpleNamedReferenceBuilder();
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$3$2$1$1 = var38_64;
                var40_69 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442;
                $i$a$-buildSimpleNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438.setName(OperatorNameConventions.SET_VALUE);
                var40_69.setCalleeReference(var38_64.build());
                $i$f$buildArgumentList = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2438 = var38_64 = new FirArgumentListBuilder();
                var40_69 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442;
                $i$a$-buildArgumentList-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2 = false;
                ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, context, false, 32, null));
                ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
                var42_71 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441.getArguments();
                $i$f$buildPropertyAccessExpression = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440 = var44_74 = new FirPropertyAccessExpressionBuilder();
                $i$a$-buildPropertyAccessExpression-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440.setSource(fakeSource);
                $i$f$buildResolvedNamedReference = false;
                var49_79 = var48_78 = new FirResolvedNamedReferenceBuilder();
                var50_80 = $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440;
                $i$a$-buildResolvedNamedReference-ConversionUtilsKt$generateAccessorsByDelegate$5$2$1$2$1$1 = false;
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setSource(fakeSource);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setResolvedSymbol(parameter.getSymbol());
                var50_80.setCalleeReference(var48_78.build());
                var43_73 = var44_74.build();
                var42_71.add(var43_73);
                var40_69.setArgumentList(var38_64.build());
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443_u24lambda_u2442.setOrigin(FirFunctionCallOrigin.Operator);
                var35_59.setResult(var33_55.build());
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443.setTarget(returnTarget);
                $this$generateAccessorsByDelegate_u24lambda_u2444_u24lambda_u2443.setSource(fakeSource);
                v20 = var26_44;
                var54_82 = var27_48.build();
                v22 = new FirSingleExpressionBlock(var54_82);
            }
            v20.setBody(v22);
            if (annotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2444.getAnnotations().addAll((Collection<FirAnnotation>)annotations);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2444.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            var20_29 = $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4.build();
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$4 = var20_29;
            $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$6 = false;
            bindFunction.invoke((Object)returnTarget, (Object)it);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it, context);
            var52_18.setSetter(var20_29);
        }
    }

    public static /* synthetic */ void generateAccessorsByDelegate$default(FirPropertyBuilder firPropertyBuilder, FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder, FirModuleData firModuleData, FirClassSymbol firClassSymbol, Context context2, boolean bl2, FirLazyExpression firLazyExpression, FirLazyBlock firLazyBlock, Function2 function2, KtSourceElement ktSourceElement, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            firLazyExpression = null;
        }
        if ((n2 & 0x40) != 0) {
            firLazyBlock = null;
        }
        if ((n2 & 0x80) != 0) {
            function2 = generateAccessorsByDelegate.1.INSTANCE;
        }
        if ((n2 & 0x100) != 0) {
            ktSourceElement = null;
        }
        ConversionUtilsKt.generateAccessorsByDelegate(firPropertyBuilder, firWrappedDelegateExpressionBuilder, firModuleData, firClassSymbol, context2, bl2, firLazyExpression, firLazyBlock, (Function2<? super FirFunctionTarget, ? super FirFunction, Unit>)function2, ktSourceElement);
    }

    @Nullable
    public static final FirContractDescription processLegacyContractDescription(@NotNull FirBlock block, @Nullable ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (ConversionUtilsKt.isContractPresentFirCheck(block)) {
            FirFunctionCall contractCall = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement(block, ConversionUtilsKt::processLegacyContractDescription$lambda$46);
            return ConversionUtilsKt.toLegacyRawContractDescription(contractCall, diagnostic);
        }
        return null;
    }

    @NotNull
    public static final FirLegacyRawContractDescription toLegacyRawContractDescription(@NotNull FirFunctionCall $this$toLegacyRawContractDescription, @Nullable ConeDiagnostic diagnostic) {
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toLegacyRawContractDescription, (String)"<this>");
        boolean $i$f$buildLegacyRawContractDescription = false;
        FirLegacyRawContractDescriptionBuilder $this$toLegacyRawContractDescription_u24lambda_u2447 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl2 = false;
        $this$toLegacyRawContractDescription_u24lambda_u2447.setSource($this$toLegacyRawContractDescription.getSource());
        $this$toLegacyRawContractDescription_u24lambda_u2447.setContractCall($this$toLegacyRawContractDescription);
        $this$toLegacyRawContractDescription_u24lambda_u2447.setDiagnostic(diagnostic);
        return firLegacyRawContractDescriptionBuilder.build();
    }

    public static /* synthetic */ FirLegacyRawContractDescription toLegacyRawContractDescription$default(FirFunctionCall firFunctionCall, ConeDiagnostic coneDiagnostic, int n2, Object object) {
        if ((n2 & 1) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.toLegacyRawContractDescription(firFunctionCall, coneDiagnostic);
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        return ConversionUtilsKt.isContractBlockFirCheck(firstStatement);
    }

    public static final boolean isContractBlockFirCheck(@NotNull FirStatement $this$isContractBlockFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractBlockFirCheck, (String)"<this>");
        FirFunctionCall firFunctionCall = $this$isContractBlockFirCheck instanceof FirFunctionCall ? (FirFunctionCall)$this$isContractBlockFirCheck : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirCall $this$arguments$iv = contractCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (!((firExpression != null ? FirExpressionUtilKt.unwrapArgument(firExpression) : null) instanceof FirAnonymousFunctionExpression)) {
            return false;
        }
        FirExpression firExpression2 = contractCall.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        FirReference firReference = receiver.getCalleeReference();
        Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (object == null || (object = ((FirNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Object receiverName = object;
        return Intrinsics.areEqual((Object)receiverName, (Object)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression createSafeCall(@NotNull FirQualifiedAccessExpression $this$createSafeCall, @NotNull FirExpression receiver, @NotNull KtSourceElement source) {
        void $this$createSafeCall_u24lambda_u2452_u24lambda_u2451;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder;
        Object $this$arguments$iv;
        void $this$createSafeCall_u24lambda_u2449_u24lambda_u2448;
        FirExpressionRef<FirExpression> firExpressionRef;
        Intrinsics.checkNotNullParameter((Object)$this$createSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder = new FirCheckedSafeCallSubjectBuilder();
        Object $this$createSafeCall_u24lambda_u2449 = firCheckedSafeCallSubjectBuilder;
        boolean bl2 = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef = new FirExpressionRef<FirExpression>();
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder2 = $this$createSafeCall_u24lambda_u2449;
        boolean bl3 = false;
        $this$createSafeCall_u24lambda_u2449_u24lambda_u2448.bind(receiver);
        firCheckedSafeCallSubjectBuilder2.setOriginalReceiverRef(firExpressionRef);
        KtSourceElement ktSourceElement = receiver.getSource();
        ((FirCheckedSafeCallSubjectBuilder)$this$createSafeCall_u24lambda_u2449).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE, 0, 0, 6, null) : null);
        FirCheckedSafeCallSubject checkedSafeCallSubject = firCheckedSafeCallSubjectBuilder.build();
        if ($this$createSafeCall instanceof FirImplicitInvokeCall) {
            boolean $i$f$buildArgumentList = false;
            Object $this$createSafeCall_u24lambda_u2450 = $this$createSafeCall_u24lambda_u2449 = new FirArgumentListBuilder();
            boolean bl4 = false;
            ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2450).getArguments().add(checkedSafeCallSubject);
            $this$arguments$iv = (FirCall)((Object)$this$createSafeCall);
            boolean $i$f$getArguments = false;
            ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2450).getArguments().addAll((Collection<FirExpression>)$this$arguments$iv.getArgumentList().getArguments());
            FirArgumentList newArguments2 = ((FirArgumentListBuilder)$this$createSafeCall_u24lambda_u2449).build();
            ((FirImplicitInvokeCall)$this$createSafeCall).replaceArgumentList(newArguments2);
        } else {
            $this$createSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        }
        boolean $i$f$buildSafeCallExpression = false;
        FirSafeCallExpressionBuilder $this$createSafeCall_u24lambda_u2452 = firSafeCallExpressionBuilder = new FirSafeCallExpressionBuilder();
        boolean bl5 = false;
        $this$createSafeCall_u24lambda_u2452.setReceiver(receiver);
        FirExpressionRef<FirCheckedSafeCallSubject> firExpressionRef3 = new FirExpressionRef<FirCheckedSafeCallSubject>();
        $this$arguments$iv = firExpressionRef3;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder2 = $this$createSafeCall_u24lambda_u2452;
        boolean bl6 = false;
        $this$createSafeCall_u24lambda_u2452_u24lambda_u2451.bind((FirExpression)checkedSafeCallSubject);
        firSafeCallExpressionBuilder2.setCheckedSubjectRef(firExpressionRef3);
        $this$createSafeCall_u24lambda_u2452.setSelector($this$createSafeCall);
        $this$createSafeCall_u24lambda_u2452.setSource(source);
        return firSafeCallExpressionBuilder.build();
    }

    @NotNull
    public static final FirExpression pullUpSafeCallIfNecessary(@NotNull FirQualifiedAccessExpression $this$pullUpSafeCallIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$pullUpSafeCallIfNecessary, (String)"<this>");
        return ConversionUtilsKt.pullUpSafeCallIfNecessary((FirExpression)$this$pullUpSafeCallIfNecessary, (Function1)pullUpSafeCallIfNecessary.1.INSTANCE, pullUpSafeCallIfNecessary.2.INSTANCE);
    }

    @NotNull
    public static final <F extends FirExpression> FirExpression pullUpSafeCallIfNecessary(@NotNull F $this$pullUpSafeCallIfNecessary, @NotNull Function1<? super F, ? extends FirExpression> obtainReceiver, @NotNull Function2<? super F, ? super FirExpression, Unit> replaceReceiver) {
        Intrinsics.checkNotNullParameter($this$pullUpSafeCallIfNecessary, (String)"<this>");
        Intrinsics.checkNotNullParameter(obtainReceiver, (String)"obtainReceiver");
        Intrinsics.checkNotNullParameter(replaceReceiver, (String)"replaceReceiver");
        Object object = obtainReceiver.invoke($this$pullUpSafeCallIfNecessary);
        FirSafeCallExpression firSafeCallExpression = object instanceof FirSafeCallExpression ? (FirSafeCallExpression)object : null;
        if (firSafeCallExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirSafeCallExpression safeCall = firSafeCallExpression;
        FirStatement firStatement = safeCall.getSelector();
        FirExpression firExpression = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
        if (firExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression safeCallSelector = firExpression;
        if (ConversionUtilsKt.isChildInParentheses(safeCall)) {
            return $this$pullUpSafeCallIfNecessary;
        }
        replaceReceiver.invoke($this$pullUpSafeCallIfNecessary, (Object)safeCallSelector);
        safeCall.replaceSelector($this$pullUpSafeCallIfNecessary);
        return safeCall;
    }

    public static final boolean isChildInParentheses(@NotNull FirStatement $this$isChildInParentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$isChildInParentheses, (String)"<this>");
        KtSourceElement ktSourceElement = $this$isChildInParentheses.getSource();
        if (ktSourceElement == null) {
            throw new IllegalStateException("Nullable source".toString());
        }
        KtSourceElement sourceElement = ktSourceElement;
        return ConversionUtilsKt.isChildInParentheses(sourceElement);
    }

    public static final boolean isChildInParentheses(@NotNull KtSourceElement $this$isChildInParentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$isChildInParentheses, (String)"<this>");
        LighterASTNode lighterASTNode = $this$isChildInParentheses.getTreeStructure().getParent($this$isChildInParentheses.getLighterASTNode());
        return Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.PARENTHESIZED);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> filterUseSiteTarget(@NotNull List<? extends FirAnnotationCall> $this$filterUseSiteTarget, @NotNull AnnotationUseSiteTarget target) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterUseSiteTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Iterable $this$mapNotNull$iv = $this$filterUseSiteTarget;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirAnnotationCall firAnnotationCall;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl3 = false;
            if (it.getUseSiteTarget() != target) {
                firAnnotationCall = null;
            } else {
                FirAnnotationCallBuilder firAnnotationCallBuilder;
                FirAnnotationCall original$iv = it;
                boolean $i$f$buildAnnotationCallCopy = false;
                FirAnnotationCallBuilder copyBuilder$iv = new FirAnnotationCallBuilder();
                copyBuilder$iv.setSource(original$iv.getSource());
                copyBuilder$iv.setUseSiteTarget(original$iv.getUseSiteTarget());
                copyBuilder$iv.setAnnotationTypeRef(original$iv.getAnnotationTypeRef());
                copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)original$iv.getTypeArguments());
                copyBuilder$iv.setArgumentList(original$iv.getArgumentList());
                copyBuilder$iv.setCalleeReference(original$iv.getCalleeReference());
                copyBuilder$iv.setArgumentMapping(original$iv.getArgumentMapping());
                copyBuilder$iv.setAnnotationResolvePhase(original$iv.getAnnotationResolvePhase());
                copyBuilder$iv.setContainingDeclarationSymbol(original$iv.getContainingDeclarationSymbol());
                FirAnnotationCallBuilder $this$filterUseSiteTarget_u24lambda_u2454_u24lambda_u2453 = firAnnotationCallBuilder = copyBuilder$iv;
                boolean bl4 = false;
                KtSourceElement ktSourceElement = it.getSource();
                $this$filterUseSiteTarget_u24lambda_u2454_u24lambda_u2453.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE, 0, 0, 6, null) : null);
                firAnnotationCall = firAnnotationCallBuilder.build();
            }
            if (firAnnotationCall == null) continue;
            FirAnnotationCall it$iv$iv = firAnnotationCall;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final FirReceiverParameter createReceiverParameter(@NotNull AbstractRawFirBuilder<?> $this$createReceiverParameter, @NotNull Function0<? extends FirTypeRef> typeRefCalculator, @NotNull FirModuleData moduleData, @NotNull FirCallableSymbol<?> containingCallableSymbol) {
        void $this$iv;
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter($this$createReceiverParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeRefCalculator, (String)"typeRefCalculator");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter(containingCallableSymbol, (String)"containingCallableSymbol");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$createReceiverParameter_u24lambda_u2457 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl2 = false;
        $this$createReceiverParameter_u24lambda_u2457.setSymbol(new FirReceiverParameterSymbol());
        AbstractRawFirBuilder<?> abstractRawFirBuilder = $this$createReceiverParameter;
        FirBasedSymbol symbol$iv = $this$createReceiverParameter_u24lambda_u2457.getSymbol();
        boolean isLocal$iv = false;
        boolean $i$f$withContainerSymbol = false;
        $this$iv.getContext().pushContainerSymbol(symbol$iv);
        try {
            void $this$filterNotTo$iv$iv;
            boolean bl3 = false;
            FirTypeRef typeRef = (FirTypeRef)typeRefCalculator.invoke();
            KtSourceElement ktSourceElement = typeRef.getSource();
            $this$createReceiverParameter_u24lambda_u2457.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null) : null);
            Collection collection = $this$createReceiverParameter_u24lambda_u2457.getAnnotations();
            List<FirAnnotation> list = typeRef.getAnnotations();
            Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
            CollectionsKt.addAll((Collection)collection, (Iterable)ConversionUtilsKt.filterUseSiteTarget(list, AnnotationUseSiteTarget.RECEIVER));
            Iterable $this$filterNot$iv = typeRef.getAnnotations();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirAnnotation it = (FirAnnotation)element$iv$iv;
                boolean bl4 = false;
                if (it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredTypeRefAnnotations = (List)destination$iv$iv;
            if (filteredTypeRefAnnotations.size() != typeRef.getAnnotations().size()) {
                typeRef.replaceAnnotations(filteredTypeRefAnnotations);
            }
            $this$createReceiverParameter_u24lambda_u2457.setTypeRef(typeRef);
            $this$createReceiverParameter_u24lambda_u2457.setModuleData(moduleData);
            $this$createReceiverParameter_u24lambda_u2457.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$createReceiverParameter_u24lambda_u2457.setContainingDeclarationSymbol((FirBasedSymbol)containingCallableSymbol);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            $this$iv.getContext().popContainerSymbol(symbol$iv);
            throw throwable;
        }
        $this$iv.getContext().popContainerSymbol(symbol$iv);
        return firReceiverParameterBuilder.build();
    }

    @NotNull
    public static final FirReceiverParameter asReceiverParameter(@NotNull KtSourceElement $this$asReceiverParameter, @NotNull FirModuleData moduleData, @NotNull FirCallableSymbol<?> containingCallableSymbol) {
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asReceiverParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter(containingCallableSymbol, (String)"containingCallableSymbol");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$asReceiverParameter_u24lambda_u2458 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl2 = false;
        $this$asReceiverParameter_u24lambda_u2458.setSource(KtSourceElementKt.fakeElement$default($this$asReceiverParameter, KtFakeSourceElementKind.ReceiverFromType.INSTANCE, 0, 0, 6, null));
        $this$asReceiverParameter_u24lambda_u2458.setTypeRef(FirImplicitTypeRefImplWithoutSource.INSTANCE);
        $this$asReceiverParameter_u24lambda_u2458.setSymbol(new FirReceiverParameterSymbol());
        $this$asReceiverParameter_u24lambda_u2458.setModuleData(moduleData);
        $this$asReceiverParameter_u24lambda_u2458.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        $this$asReceiverParameter_u24lambda_u2458.setContainingDeclarationSymbol((FirBasedSymbol)containingCallableSymbol);
        return firReceiverParameterBuilder.build();
    }

    public static final <T> void initContainingClassAttr(@NotNull FirCallableDeclaration $this$initContainingClassAttr, @NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter((Object)$this$initContainingClassAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Object object = ConversionUtilsKt.currentDispatchReceiverType(context2);
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$initContainingClassAttr, (ConeClassLikeLookupTag)object);
    }

    @Nullable
    public static final <T> ConeClassLikeType currentDispatchReceiverType(@NotNull Context<T> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        return (ConeClassLikeType)CollectionsKt.lastOrNull(context2.getDispatchReceiverTypesStack());
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isUnderscore, (String)"<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int i2 = 0; i2 < $this$all$iv.length(); ++i2) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i2);
                boolean bl3 = false;
                if (it == '_') continue;
                bl2 = false;
                break block1;
            }
            bl2 = true;
        }
        return bl2;
    }

    @NotNull
    public static final FirExpression buildBalancedOrExpressionTree(@NotNull List<? extends FirExpression> conditions, int lower2, int upper) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        int size = upper - lower2 + 1;
        int middle = size / 2 + lower2;
        if (lower2 == upper) {
            return conditions.get(middle);
        }
        FirExpression leftNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions, lower2, middle - 1);
        FirExpression rightNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions, middle, upper);
        KtSourceElement ktSourceElement = leftNode.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = rightNode.getSource();
        }
        return ConversionUtilsKt.generateLazyLogicalOperation(leftNode, rightNode, false, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.WhenCondition.INSTANCE, 0, 0, 6, null) : null);
    }

    public static /* synthetic */ FirExpression buildBalancedOrExpressionTree$default(List list, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = CollectionsKt.getLastIndex((List)list);
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree(list, n2, n3);
    }

    @NotNull
    public static final FirExpression guardedBy(@NotNull FirExpression $this$guardedBy, @Nullable FirExpression guard) {
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)$this$guardedBy, (String)"<this>");
        if (guard == null) {
            firExpression = $this$guardedBy;
        } else {
            KtSourceElement ktSourceElement = $this$guardedBy.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = guard.getSource();
            }
            firExpression = ConversionUtilsKt.generateLazyLogicalOperation($this$guardedBy, guard, true, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.WhenCondition.INSTANCE, 0, 0, 6, null) : null);
        }
        return firExpression;
    }

    public static final boolean appliesToPrimaryConstructorParameter(@Nullable AnnotationUseSiteTarget $this$appliesToPrimaryConstructorParameter) {
        return $this$appliesToPrimaryConstructorParameter == null || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.RECEIVER || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.FILE || $this$appliesToPrimaryConstructorParameter == AnnotationUseSiteTarget.ALL;
    }

    @NotNull
    public static final FirResolvedTypeRef wrapIntoArray(@NotNull FirErrorTypeRef $this$wrapIntoArray) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$wrapIntoArray, (String)"<this>");
        FirErrorTypeRef typeRef = $this$wrapIntoArray;
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$wrapIntoArray_u24lambda_u2460 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl2 = false;
        $this$wrapIntoArray_u24lambda_u2460.setSource(typeRef.getSource());
        ConeKotlinTypeProjectionOut[] coneKotlinTypeProjectionOutArray = new ConeKotlinTypeProjectionOut[]{new ConeKotlinTypeProjectionOut(typeRef.getConeType())};
        $this$wrapIntoArray_u24lambda_u2460.setConeType(TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getArray(), coneKotlinTypeProjectionOutArray, false, null, 6, null));
        $this$wrapIntoArray_u24lambda_u2460.setDelegatedTypeRef(UtilsKt.copyWithNewSourceKind((FirTypeRef)typeRef, KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE));
        return firResolvedTypeRefBuilder.build();
    }

    public static final boolean shouldGenerateDelegatedSuperCall(boolean isAnySuperCall, boolean isExpectClass, boolean isEnumEntry, boolean hasExplicitDelegatedCalls) {
        if (isAnySuperCall) {
            return false;
        }
        if (isExpectClass) {
            return !isEnumEntry && hasExplicitDelegatedCalls;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, KtSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context, boolean forDispatchReceiver) {
        FirExpression firExpression;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416;
            boolean bl3 = false;
            FirReceiverParameter firReceiverParameter = $this_generateAccessorsByDelegate.getReceiverParameter();
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415.setBoundSymbol(firReceiverParameter != null ? firReceiverParameter.getSymbol() : null);
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2416_u24lambda_u2415 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417.setBoundSymbol((FirThisOwnerSymbol)$ownerRegularOrAnonymousObjectSymbol);
            firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setConeTypeOrNull((ConeKotlinType)CollectionsKt.last($context.getDispatchReceiverTypesStack()));
            firExpression = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression = FirConstExpressionBuilderKt.buildLiteralExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, false, null, 40, null);
        }
        return firExpression;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl2, FirClassSymbol firClassSymbol, KtSourceElement ktSourceElement, FirPropertyBuilder firPropertyBuilder, Context context2, boolean bl3, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl2, firClassSymbol, ktSourceElement, firPropertyBuilder, context2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(KtSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Context<T> $context) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420;
        boolean bl3 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setResolvedSymbol(delegateFieldSymbol);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $context, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(KtSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$mapTo$iv;
        ConeKotlinType coneKotlinType;
        Object $i$f$buildResolvedNamedReference2;
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference2 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        Object object = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425;
        boolean bl3 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2421.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        ((FirCallableReferenceAccessBuilder)object).setCalleeReference(firResolvedNamedReferenceBuilder.build());
        if (!isMember && !$isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty0(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else if (isMember && $isExtension) {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty2(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        } else {
            ConeClassLikeType coneClassLikeType;
            if (isVar) {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKMutableProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            } else {
                $i$f$buildResolvedNamedReference2 = new ConeStarProjection[]{ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE};
                coneClassLikeType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getKProperty1(), $i$f$buildResolvedNamedReference2, false, null, 6, null);
            }
            coneKotlinType = coneClassLikeType;
        }
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.setConeTypeOrNull(coneKotlinType);
        $i$f$buildResolvedNamedReference2 = $this_generateAccessorsByDelegate.getTypeParameters();
        Collection destination$iv = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv;
            object = destination$iv;
            boolean bl4 = false;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl5 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423.setVariance(Variance.INVARIANT);
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423;
            boolean bl6 = false;
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setConeType(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
            $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setSource(fakeSource);
            firTypeProjectionWithVarianceBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
            object.add(firTypeProjectionWithVarianceBuilder.build());
        }
        return firCallableReferenceAccessBuilder.build();
    }

    private static final FirStatement processLegacyContractDescription$lambda$46(FirFunctionCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new FirContractCallBlock(it);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('t'), (Object)new CharacterWithDiagnostic('\t')), TuplesKt.to((Object)Character.valueOf('b'), (Object)new CharacterWithDiagnostic('\b')), TuplesKt.to((Object)Character.valueOf('n'), (Object)new CharacterWithDiagnostic('\n')), TuplesKt.to((Object)Character.valueOf('r'), (Object)new CharacterWithDiagnostic('\r')), TuplesKt.to((Object)Character.valueOf('\''), (Object)new CharacterWithDiagnostic('\'')), TuplesKt.to((Object)Character.valueOf('\"'), (Object)new CharacterWithDiagnostic('\"')), TuplesKt.to((Object)Character.valueOf('\\'), (Object)new CharacterWithDiagnostic('\\')), TuplesKt.to((Object)Character.valueOf('$'), (Object)new CharacterWithDiagnostic('$'))};
        escapeCharToChartedWithDiagnosticMap = MapsKt.hashMapOf((Pair[])pairArray);
        illegalEscapeDiagnostic = new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
        pairArray = new Pair[]{TuplesKt.to((Object)KtTokens.LT, (Object)((Object)FirOperation.LT)), TuplesKt.to((Object)KtTokens.GT, (Object)((Object)FirOperation.GT)), TuplesKt.to((Object)KtTokens.LTEQ, (Object)((Object)FirOperation.LT_EQ)), TuplesKt.to((Object)KtTokens.GTEQ, (Object)((Object)FirOperation.GT_EQ)), TuplesKt.to((Object)KtTokens.EQEQ, (Object)((Object)FirOperation.EQ)), TuplesKt.to((Object)KtTokens.EXCLEQ, (Object)((Object)FirOperation.NOT_EQ)), TuplesKt.to((Object)KtTokens.EQEQEQ, (Object)((Object)FirOperation.IDENTITY)), TuplesKt.to((Object)KtTokens.EXCLEQEQEQ, (Object)((Object)FirOperation.NOT_IDENTITY)), TuplesKt.to((Object)KtTokens.EQ, (Object)((Object)FirOperation.ASSIGN)), TuplesKt.to((Object)KtTokens.PLUSEQ, (Object)((Object)FirOperation.PLUS_ASSIGN)), TuplesKt.to((Object)KtTokens.MINUSEQ, (Object)((Object)FirOperation.MINUS_ASSIGN)), TuplesKt.to((Object)KtTokens.MULTEQ, (Object)((Object)FirOperation.TIMES_ASSIGN)), TuplesKt.to((Object)KtTokens.DIVEQ, (Object)((Object)FirOperation.DIV_ASSIGN)), TuplesKt.to((Object)KtTokens.PERCEQ, (Object)((Object)FirOperation.REM_ASSIGN)), TuplesKt.to((Object)KtTokens.IS_KEYWORD, (Object)((Object)FirOperation.IS)), TuplesKt.to((Object)KtTokens.NOT_IS, (Object)((Object)FirOperation.NOT_IS)), TuplesKt.to((Object)KtTokens.AS_KEYWORD, (Object)((Object)FirOperation.AS)), TuplesKt.to((Object)KtTokens.AS_SAFE, (Object)((Object)FirOperation.SAFE_AS))};
        ktTokenToFirOperationMap = MapsKt.hashMapOf((Pair[])pairArray);
    }
}

