/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaClassOnCompanionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaClassOnCompanionChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,47:1\n65#2:48\n*S KotlinDebug\n*F\n+ 1 FirJavaClassOnCompanionChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker\n*L\n37#1:48\n*E\n"})
public final class FirJavaClassOnCompanionChecker
extends FirExpressionChecker<FirPropertyAccessExpression> {
    @NotNull
    public static final FirJavaClassOnCompanionChecker INSTANCE = new FirJavaClassOnCompanionChecker();

    private FirJavaClassOnCompanionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirPropertyAccessExpression expression2) {
        boolean bl2;
        FirRegularClassSymbol projectionClassSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirBasedSymbol<?> firBasedSymbol = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firBasedSymbol instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)((Object)firBasedSymbol) : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        firBasedSymbol = FirReferenceUtilsKt.getSymbol(reference2);
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (!Intrinsics.areEqual((Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null), (Object)JvmStandardClassIds.Callables.INSTANCE.getJavaClass())) {
            return;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(expression2);
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType actualType = coneClassLikeType;
        Object object = ArraysKt.singleOrNull((Object[])actualType.getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object : null;
        if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return;
        }
        ConeKotlinTypeProjection projectionType = coneKotlinTypeProjection;
        FirRegularClassSymbol firRegularClassSymbol = projectionClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)projectionType, context2.getSession());
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl2 = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl2 = false;
        }
        if (!bl2) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(projectionClassSymbol);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> containingClassSymbol = firClassLikeSymbol;
        ConeClassLikeType[] coneClassLikeTypeArray = new ConeClassLikeType[]{ScopeUtilsKt.defaultType(containingClassSymbol)};
        ConeClassLikeType expectedType = TypeConstructionUtilsKt.constructClassType$default(actualType.getLookupTag(), coneClassLikeTypeArray, actualType.isMarkedNullable(), null, 4, null);
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJAVA_CLASS_ON_COMPANION(), (Object)actualType, (Object)expectedType, null, 32, null);
    }
}

