/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import ksp.org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import ksp.org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import ksp.org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import ksp.org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import ksp.org.jetbrains.kotlin.fir.contracts.FirErrorContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeContractMayNotHaveLabel;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeContractDescriptionError;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J5\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001aJ5\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u001dH\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\u001f\u001a\u00020\u001c*\u00020\u0002H\u0002J-\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\"J5\u0010#\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010&J9\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "EMPTY_CONTRACT_MESSAGE", "", "DUPLICATE_CALLS_IN_PLACE_MESSAGE", "INVALID_CONTRACT_BLOCK", "CALLS_IN_PLACE_ON_CONTEXT_PARAMETER", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkAnnotationsNotAllowed", "contractCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkUnresolvedEffects", "contractDescription", "Lksp/org/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkContractNotAllowed", "", "Lksp/org/jetbrains/kotlin/fir/contracts/FirContractDescription;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;)Z", "isContractOnOperatorForbidden", "checkDuplicateCallsInPlace", "description", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;)V", "checkCallsInPlaceOnContextParameter", "valueParametersCount", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;I)V", "checkDiagnosticsFromFirBuilder", "diagnostic", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;)V", "DiagnosticExtractor", "ErasedCastChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n81#2,7:370\n76#2,2:377\n57#2:379\n78#2:380\n46#3:381\n1#4:382\n1#4:398\n14#5,2:383\n39#5:385\n40#5:386\n23#5:387\n1617#6,9:388\n1869#6:397\n1870#6:399\n1626#6:400\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n79#1:370,7\n79#1:377,2\n79#1:379\n79#1:380\n89#1:381\n205#1:398\n156#1:383,2\n156#1:385\n159#1:386\n167#1:387\n205#1:388,9\n205#1:397\n205#1:399\n205#1:400\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";
    @NotNull
    private static final String DUPLICATE_CALLS_IN_PLACE_MESSAGE = "A value parameter may not be annotated with callsInPlace twice";
    @NotNull
    private static final String INVALID_CONTRACT_BLOCK = "Contract block could not be resolved";
    @NotNull
    private static final String CALLS_IN_PLACE_ON_CONTEXT_PARAMETER = "callsInPlace contract cannot be applied to context parameter because context arguments can never be lambdas.";

    private FirContractChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration2) {
        FirContractDescription firContractDescription;
        FirFunctionCall contractCall;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!(declaration2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription2 = ((FirContractDescriptionOwner)((Object)declaration2)).getContractDescription();
        if (firContractDescription2 == null) {
            return;
        }
        FirContractDescription contractDescription = firContractDescription2;
        boolean reportedNotAllowed = this.checkContractNotAllowed(context2, reporter, declaration2, contractDescription);
        if (reportedNotAllowed) {
            return;
        }
        Object object = ((FirContractDescriptionOwner)((Object)declaration2)).getBody();
        FirStatement firStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.firstOrNull((List)object) : null;
        FirContractCallBlock firContractCallBlock = firStatement instanceof FirContractCallBlock ? (FirContractCallBlock)firStatement : null;
        FirFunctionCall firFunctionCall = contractCall = firContractCallBlock != null ? firContractCallBlock.getCall() : null;
        if (contractCall != null) {
            this.checkAnnotationsNotAllowed(context2, reporter, contractCall);
        }
        if ((firContractDescription = contractDescription) instanceof FirResolvedContractDescription) {
            this.checkUnresolvedEffects(context2, reporter, (FirResolvedContractDescription)contractDescription, declaration2);
            this.checkDuplicateCallsInPlace(context2, reporter, (FirResolvedContractDescription)contractDescription);
            if (!((Collection)declaration2.getContextParameters()).isEmpty()) {
                this.checkCallsInPlaceOnContextParameter(context2, reporter, (FirResolvedContractDescription)contractDescription, ((FirContractDescriptionOwner)((Object)declaration2)).getValueParameters().size());
            }
            if (((FirResolvedContractDescription)contractDescription).getEffects().isEmpty() && ((FirResolvedContractDescription)contractDescription).getUnresolvedEffects().isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedContractDescription)contractDescription).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, null, 16, null);
            }
            this.checkDiagnosticsFromFirBuilder(context2, reporter, ((FirResolvedContractDescription)contractDescription).getDiagnostic(), ((FirResolvedContractDescription)contractDescription).getSource());
        } else if (firContractDescription instanceof FirErrorContractDescription) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirErrorContractDescription)contractDescription).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)INVALID_CONTRACT_BLOCK, null, 16, null);
            this.checkDiagnosticsFromFirBuilder(context2, reporter, ((FirErrorContractDescription)contractDescription).getDiagnostic(), ((FirErrorContractDescription)contractDescription).getSource());
        } else {
            if (firContractDescription instanceof FirRawContractDescription || firContractDescription instanceof FirLegacyRawContractDescription) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                void $this$buildAttachment$iv$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                void cause$iv$iv;
                void message$iv$iv;
                String message$iv = "Unexpected contract description kind: " + Reflection.getOrCreateKotlinClass(contractDescription.getClass()).getSimpleName();
                Object cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                String string = message$iv;
                Object var13_13 = cause$iv;
                String attachmentName$iv$iv = attachmentName$iv;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
                String name$iv$iv$iv = attachmentName$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = name$iv$iv$iv;
                void var23_23 = $this$buildAttachment$iv$iv$iv;
                boolean bl2 = false;
                void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl3 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "declaration", declaration2);
                var23_23.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void checkAnnotationsNotAllowed(CheckerContext context2, DiagnosticReporter reporter, FirFunctionCall contractCall) {
        FirCall $this$arguments$iv = contractCall;
        boolean $i$f$getArguments = false;
        Object object = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = object instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)object : null;
        if (firAnonymousFunctionExpression == null) {
            return;
        }
        FirAnonymousFunctionExpression argument = firAnonymousFunctionExpression;
        if (!argument.getAnonymousFunction().isLambda()) {
            return;
        }
        FirBlock firBlock = argument.getAnonymousFunction().getBody();
        if (firBlock == null) {
            return;
        }
        FirBlock lambdaBody = firBlock;
        lambdaBody.acceptChildren(new FirVisitorVoid(context2, reporter){
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$context = $context;
                this.$reporter = $reporter;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitAnnotation(FirAnnotation annotation) {
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), null, 8, null);
            }

            public void visitAnnotationCall(FirAnnotationCall annotationCall) {
                Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)annotationCall.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), null, 8, null);
            }
        });
    }

    private final void checkUnresolvedEffects(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription contractDescription, FirFunction declaration2) {
        ConeDiagnostic diagnostic;
        ErasedCastChecker erasedCastChecker = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowCheckForErasedTypesInContracts) ? null : new ErasedCastChecker(declaration2, context2);
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null);
            if (coneDiagnostic == null) {
                ConeDiagnostic coneDiagnostic2;
                if (erasedCastChecker != null) {
                    ErasedCastChecker it;
                    boolean bl2 = false;
                    coneDiagnostic2 = (ConeDiagnostic)unresolvedEffect.getEffect().accept(it, null);
                } else {
                    coneDiagnostic2 = coneDiagnostic = null;
                }
                if (coneDiagnostic2 == null) continue;
            }
            diagnostic = coneDiagnostic;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), null, 16, null);
        }
        if (erasedCastChecker != null) {
            for (FirEffectDeclaration resolvedEffect : contractDescription.getEffects()) {
                if ((ConeDiagnostic)resolvedEffect.getEffect().accept(erasedCastChecker, null) == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)resolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), null, 16, null);
            }
        }
    }

    private final boolean checkContractNotAllowed(CheckerContext context2, DiagnosticReporter reporter, FirFunction declaration2, FirContractDescription contractDescription) {
        block6: {
            KtSourceElement source;
            block9: {
                block10: {
                    block8: {
                        block7: {
                            block4: {
                                block5: {
                                    KtSourceElement ktSourceElement = source = contractDescription.getSource();
                                    if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                                        return false;
                                    }
                                    if (!(declaration2 instanceof FirPropertyAccessor) && !(declaration2 instanceof FirAnonymousFunction)) break block4;
                                    if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowContractsOnPropertyAccessors)) break block5;
                                    if (!(declaration2 instanceof FirAnonymousFunction)) break block6;
                                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for anonymous functions.");
                                    break block6;
                                }
                                FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are only allowed for functions.");
                                break block6;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration2;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block7;
                            FirMemberDeclaration $this$isOpen$iv = declaration2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block7;
                            FirMemberDeclaration $this$isOverride$iv = declaration2;
                            boolean $i$f$isOverride = false;
                            if (!$this$isOverride$iv.getStatus().isOverride()) break block8;
                        }
                        FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for open or override functions.");
                        break block6;
                    }
                    FirMemberDeclaration $this$isOperator$iv = declaration2;
                    boolean $i$f$isOperator = false;
                    if (!$this$isOperator$iv.getStatus().isOperator()) break block9;
                    if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowContractsOnSomeOperators)) break block10;
                    if (!this.isContractOnOperatorForbidden(declaration2)) break block6;
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for operator " + FirDeclarationUtilKt.getNameOrSpecialName(declaration2) + '.');
                    break block6;
                }
                FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for operator functions.");
                break block6;
            }
            if (!declaration2.getSymbol().getCallableId().isLocal()) {
                FirMemberDeclaration $this$visibility$iv = declaration2;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
                    return false;
                }
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for local functions.");
        }
        return true;
    }

    private final boolean isContractOnOperatorForbidden(FirFunction $this$isContractOnOperatorForbidden) {
        Name name2 = FirDeclarationUtilKt.getNameOrSpecialName($this$isContractOnOperatorForbidden);
        return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PROVIDE_DELEGATE) ? true : Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PLUS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.MINUS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TIMES) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.DIV) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.REM) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PLUS_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.MINUS_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TIMES_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.DIV_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.REM_ASSIGN);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDuplicateCallsInPlace(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription description) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = description.getEffects();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtCallsEffectDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirEffectDeclaration it = (FirEffectDeclaration)element$iv$iv;
            boolean bl3 = false;
            KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> ktEffectDeclaration = it.getEffect();
            if ((ktEffectDeclaration instanceof KtCallsEffectDeclaration ? (KtCallsEffectDeclaration)ktEffectDeclaration : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List callsInPlaceEffects = (List)destination$iv$iv;
        Set seenParameterIndices = new LinkedHashSet();
        for (KtCallsEffectDeclaration effect : callsInPlaceEffects) {
            int parameterIndex = effect.getValueParameterReference().getParameterIndex();
            if (seenParameterIndices.contains(parameterIndex)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)DUPLICATE_CALLS_IN_PLACE_MESSAGE, null, 16, null);
                continue;
            }
            seenParameterIndices.add(parameterIndex);
        }
    }

    private final void checkCallsInPlaceOnContextParameter(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription description, int valueParametersCount) {
        for (FirEffectDeclaration effectDeclaration : description.getEffects()) {
            KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> effect = effectDeclaration.getEffect();
            if (!(effect instanceof KtCallsEffectDeclaration) || ((KtCallsEffectDeclaration)effect).getValueParameterReference().getParameterIndex() < valueParametersCount) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)CALLS_IN_PLACE_ON_CONTEXT_PARAMETER, null, 16, null);
        }
    }

    private final void checkDiagnosticsFromFirBuilder(CheckerContext context2, DiagnosticReporter reporter, ConeDiagnostic diagnostic, KtSourceElement source) {
        if (Intrinsics.areEqual((Object)diagnostic, (Object)ConeContractMayNotHaveLabel.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)ConeContractMayNotHaveLabel.INSTANCE.getReason(), null, 16, null);
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement source, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\tj\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000ej\u0002`\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0012j\u0002`\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0016j\u0002`\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001cj\u0002`\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020 j\u0002`!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\"\u001a\u0004\u0018\u00010\u00022\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020$j\u0002`%2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010&\u001a\u00020\u00022\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010(\u001a\u0004\u0018\u00010\u00022\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020*j\u0002`+2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010,\u001a\u00020\u00022\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020.2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010/\u001a\u00020\u00022\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00102\u001a\u00020\u00022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u00065"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "visitContractDescriptionElement", "contractDescriptionElement", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitReturnsEffectDeclaration", "returnsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "visitErroneousCallsEffectDeclaration", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lksp/org/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lksp/org/jetbrains/kotlin/contracts/description/KtLogicalNot;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitErroneousIsInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitErroneousConstantReference", "erroneousConstantReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousValueParameterReference", "valueParameterReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitErroneousElement", "element", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element2, (String)"element");
            return element2.getDiagnostic();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker;", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitContractDescriptionElement", "contractDescriptionElement", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "visitIsInstancePredicate", "isInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lksp/org/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lksp/org/jetbrains/kotlin/contracts/description/KtLogicalNot;", "getParameterType", "index", "", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,369:1\n282#2:370\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n*L\n342#1:370\n*E\n"})
    private static final class ErasedCastChecker
    extends KtContractDescriptionVisitor {
        @NotNull
        private final FirFunction declaration;
        @NotNull
        private final CheckerContext context;

        public ErasedCastChecker(@NotNull FirFunction declaration2, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.declaration = declaration2;
            this.context = context2;
        }

        @NotNull
        public final FirFunction getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            return (ConeDiagnostic)conditionalEffect.getCondition().accept(this, data);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            ConeContractDescriptionError.ErasedIsCheck erasedIsCheck;
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            ConeKotlinType parameterType = this.getParameterType(isInstancePredicate.getArg().getParameterIndex());
            CheckerContext $this$visitIsInstancePredicate_u24lambda_u241 = this.context;
            boolean bl2 = false;
            boolean $this$ifTrue$iv = FirCastDiagnosticsHelpersKt.isCastErased($this$visitIsInstancePredicate_u24lambda_u241, parameterType, isInstancePredicate.getType());
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                boolean bl3 = false;
                erasedIsCheck = ConeContractDescriptionError.ErasedIsCheck.INSTANCE;
            } else {
                erasedIsCheck = null;
            }
            return erasedIsCheck;
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, data);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, data);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, data);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final ConeKotlinType getParameterType(int index2) {
            ConeKotlinType coneKotlinType;
            int n2 = index2;
            if (n2 == -1) {
                coneKotlinType = this.declaration.getSymbol().getResolvedReceiverType();
                if (coneKotlinType != null) return coneKotlinType;
                ConeSimpleKotlinType coneSimpleKotlinType = this.declaration.getSymbol().getDispatchReceiverType();
                if (coneSimpleKotlinType == null) throw new IllegalStateException("Contract references non-existent receiver".toString());
                coneKotlinType = coneSimpleKotlinType;
                return coneKotlinType;
            }
            coneKotlinType = (0 <= n2 ? n2 < ((Collection)this.declaration.getValueParameters()).size() : false) ? FirTypeUtilsKt.getConeType(this.declaration.getValueParameters().get(index2).getReturnTypeRef()) : FirTypeUtilsKt.getConeType(this.declaration.getContextParameters().get(index2 - this.declaration.getValueParameters().size()).getReturnTypeRef());
            return coneKotlinType;
        }
    }
}

