/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import ksp.org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import ksp.org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import ksp.org.jetbrains.kotlin.contracts.model.ESEffect;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/contracts/interpretation/CallsEffectInterpreter;", "Lksp/org/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "dispatcher", "Lksp/org/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "tryInterpret", "Lksp/org/jetbrains/kotlin/contracts/model/ESEffect;", "effectDeclaration", "Lksp/org/jetbrains/kotlin/contracts/description/EffectDeclaration;", "resolution"})
public final class CallsEffectInterpreter
implements EffectDeclarationInterpreter {
    @NotNull
    private final ContractInterpretationDispatcher dispatcher;

    public CallsEffectInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public ESEffect tryInterpret(@NotNull EffectDeclaration effectDeclaration) {
        Intrinsics.checkNotNullParameter((Object)effectDeclaration, (String)"effectDeclaration");
        if (!(effectDeclaration instanceof CallsEffectDeclaration)) {
            return null;
        }
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(((CallsEffectDeclaration)effectDeclaration).getVariableReference());
        if (eSVariable == null) {
            return null;
        }
        ESVariable variable = eSVariable;
        EventOccurrencesRange kind = ((CallsEffectDeclaration)effectDeclaration).getKind();
        return new ESCalls(variable, kind);
    }
}

