/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import ksp.org.jetbrains.kotlin.backend.common.TreeConsistencyError;
import ksp.org.jetbrains.kotlin.backend.common.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrTreeSymbolsVisitor;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001BA\u00120\u0010\u0002\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\"\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020\b2\u0006\u0010\"\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u001eH\u0002J\"\u0010-\u001a\u00020\b2\u0006\u0010\"\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0002R;\u0010\u0002\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0019j\b\u0012\u0004\u0012\u00020\u0005`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor;", "Lksp/org/jetbrains/kotlin/ir/util/IrTreeSymbolsVisitor;", "reportError", "Lkotlin/Function4;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lksp/org/jetbrains/kotlin/backend/common/ReportIrValidationError;", "config", "Lksp/org/jetbrains/kotlin/backend/common/IrValidatorConfig;", "<init>", "(Lkotlin/jvm/functions/Function4;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;)V", "getReportError", "()Lkotlin/jvm/functions/Function4;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "hasInconsistency", "", "getHasInconsistency", "()Z", "setHasInconsistency", "(Z)V", "visitedElements", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "parentChain", "", "currentActualParent", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitElement", "element", "visitDeclaration", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitPackageFragment", "Lksp/org/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitSymbol", "container", "symbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "handleParent", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "actualParent", "reportWrongParent", "expectedParent", "checkDuplicateNode", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor\n+ 2 Utils.kt\norg/jetbrains/kotlin/backend/common/UtilsKt\n*L\n1#1,581:1\n24#2,6:582\n24#2,6:588\n*S KotlinDebug\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/CheckTreeConsistencyVisitor\n*L\n367#1:582,6\n374#1:588,6\n*E\n"})
final class CheckTreeConsistencyVisitor
extends IrTreeSymbolsVisitor {
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;
    private boolean hasInconsistency;
    @NotNull
    private final HashSet<IrElement> visitedElements;
    @NotNull
    private final List<IrElement> parentChain;
    @Nullable
    private IrDeclarationParent currentActualParent;

    public CheckTreeConsistencyVisitor(@NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError, @NotNull IrValidatorConfig config) {
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.reportError = reportError;
        this.config = config;
        this.visitedElements = new HashSet();
        this.parentChain = new ArrayList();
    }

    @NotNull
    public final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    public final boolean getHasInconsistency() {
        return this.hasInconsistency;
    }

    public final void setHasInconsistency(boolean bl2) {
        this.hasInconsistency = bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull IrElement element2) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.checkDuplicateNode(element2);
        List<IrElement> list = this.parentChain;
        IrElement element$iv = element2;
        boolean $i$f$temporarilyPushing = false;
        UtilsKt.push($this$temporarilyPushing$iv, element$iv);
        IrElement it = element$iv;
        boolean bl2 = false;
        IrVisitorsKt.acceptChildrenVoid(element2, this);
        Unit result$iv = Unit.INSTANCE;
        UtilsKt.pop($this$temporarilyPushing$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.checkDuplicateNode(declaration2);
        List<IrElement> list = this.parentChain;
        IrDeclarationBase element$iv = declaration2;
        boolean $i$f$temporarilyPushing = false;
        UtilsKt.push($this$temporarilyPushing$iv, element$iv);
        IrElement it = element$iv;
        boolean bl2 = false;
        this.handleParent(declaration2, this.currentActualParent);
        IrDeclarationParent previousActualParent = this.currentActualParent;
        IrDeclarationParent irDeclarationParent = declaration2 instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration2) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = this.currentActualParent;
        }
        this.currentActualParent = irDeclarationParent;
        IrVisitorsKt.acceptChildrenVoid((IrElement)declaration2, this);
        this.currentActualParent = previousActualParent;
        Unit result$iv = Unit.INSTANCE;
        UtilsKt.pop($this$temporarilyPushing$iv);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.currentActualParent = declaration2;
        this.visitElement(declaration2);
    }

    @Override
    public void visitSymbol(@NotNull IrElement container, @NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.config.getCheckUnboundSymbols() && !symbol.isBound()) {
            this.hasInconsistency = true;
            this.reportError.invoke(null, (Object)container, (Object)"Unexpected unbound symbol", this.parentChain);
        }
    }

    private final void handleParent(IrDeclaration declaration2, IrDeclarationParent actualParent) {
        if (actualParent == null) {
            return;
        }
        try {
            IrDeclarationParent assignedParent = declaration2.getParent();
            if (!Intrinsics.areEqual((Object)assignedParent, (Object)actualParent)) {
                this.reportWrongParent(declaration2, assignedParent, actualParent);
            }
        }
        catch (Exception exception) {
            this.reportWrongParent(declaration2, null, actualParent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportWrongParent(IrDeclaration declaration2, IrDeclarationParent expectedParent, IrDeclarationParent actualParent) {
        void $this$reportWrongParent_u24lambda_u242;
        StringBuilder stringBuilder;
        this.hasInconsistency = true;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrDeclaration irDeclaration = declaration2;
        Object var8_7 = null;
        Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> function4 = this.reportError;
        boolean bl2 = false;
        $this$reportWrongParent_u24lambda_u242.append("Declaration with wrong parent:").append('\n');
        $this$reportWrongParent_u24lambda_u242.append("declaration: " + RenderIrElementKt.render$default(declaration2, null, 1, null)).append('\n');
        IrDeclarationParent irDeclarationParent = expectedParent;
        $this$reportWrongParent_u24lambda_u242.append("expectedParent: " + (irDeclarationParent != null ? RenderIrElementKt.render$default(irDeclarationParent, null, 1, null) : null)).append('\n');
        $this$reportWrongParent_u24lambda_u242.append("actualParent: " + RenderIrElementKt.render$default(actualParent, null, 1, null)).append('\n');
        Unit unit = Unit.INSTANCE;
        function4.invoke(var8_7, (Object)irDeclaration, (Object)stringBuilder.toString(), this.parentChain);
    }

    private final void checkDuplicateNode(IrElement element2) {
        if (!this.visitedElements.add(element2)) {
            String renderString = element2 instanceof IrTypeParameter ? RenderIrElementKt.render$default(element2, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element2).getParent(), null, 1, null) : RenderIrElementKt.render$default(element2, null, 1, null);
            this.reportError.invoke(null, (Object)element2, (Object)("Duplicate IR node: " + renderString), this.parentChain);
            throw new TreeConsistencyError(element2);
        }
    }
}

