/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.asJava.classes;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.codegen.AnnotationCodegen;
import ksp.org.jetbrains.kotlin.codegen.AsmUtil;
import ksp.org.jetbrains.kotlin.codegen.CodegenUtilKt;
import ksp.org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import ksp.org.jetbrains.kotlin.codegen.OwnerKind;
import ksp.org.jetbrains.kotlin.config.JvmDefaultMode;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRenderer;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

public class VisibilityUtil {
    private VisibilityUtil() {
    }

    private static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, JvmDefaultMode jvmDefaultMode) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor.getContainingDeclaration()) && !JvmAnnotationUtilKt.isCompiledToJvmDefault(functionDescriptor, jvmDefaultMode)) && !CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, DeprecationResolver deprecationResolver, JvmDefaultMode jvmDefaultMode) {
        DeclarationDescriptor containingDeclaration;
        int flags = VisibilityUtil.getCommonCallableFlags(functionDescriptor, deprecationResolver);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            flags |= flagAnnotation.getJvmFlag(functionDescriptor.getOriginal());
        }
        if (functionDescriptor.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            flags &= 0xFFFFFEFF;
        }
        if (functionDescriptor.getModality() == Modality.FINAL && !(functionDescriptor instanceof ConstructorDescriptor) && !JvmCodegenUtil.isJvmInterface(containingDeclaration = functionDescriptor.getContainingDeclaration())) {
            flags |= 0x10;
        }
        if (CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor)) {
            flags |= 8;
        }
        if (VisibilityUtil.isAbstractMethod(functionDescriptor, jvmDefaultMode)) {
            flags |= 0x400;
        }
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor) || VisibilityUtil.isInlineClassWrapperConstructor(functionDescriptor) || InlineClassDescriptorResolver.isSynthesizedBoxMethod(functionDescriptor) || InlineClassDescriptorResolver.isSynthesizedUnboxMethod(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static boolean isInlineClassWrapperConstructor(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            VisibilityUtil.$$$reportNull$$$0(0);
        }
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
        return InlineClassesUtilsKt.isInlineClass(classDescriptor);
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor, @NotNull DeprecationResolver deprecationResolver) {
        if (deprecationResolver == null) {
            VisibilityUtil.$$$reportNull$$$0(1);
        }
        int flags = VisibilityUtil.getVisibilityAccessFlag(functionDescriptor, OwnerKind.IMPLEMENTATION);
        flags |= VisibilityUtil.getVarargsFlag(functionDescriptor);
        flags |= VisibilityUtil.getDeprecatedAccessFlag(functionDescriptor);
        if (deprecationResolver.isDeprecatedHidden(functionDescriptor) || InlineOnlyKt.isInlineWithReified(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2, @Nullable OwnerKind kind) {
        Integer specialCase;
        if (descriptor2 == null) {
            VisibilityUtil.$$$reportNull$$$0(2);
        }
        if ((specialCase = VisibilityUtil.specialCaseVisibility(descriptor2, kind)) != null) {
            return specialCase;
        }
        DescriptorVisibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility.getDelegate());
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            VisibilityUtil.$$$reportNull$$$0(3);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    private static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            VisibilityUtil.$$$reportNull$$$0(4);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : VisibilityUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor, @Nullable OwnerKind kind) {
        PropertyDescriptor property2;
        if (memberDescriptor == null) {
            VisibilityUtil.$$$reportNull$$$0(5);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        DescriptorVisibility memberVisibility = memberDescriptor.getVisibility();
        if (VisibilityUtil.isNonIntrinsicPrivateCompanionObjectInInterface(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof FunctionDescriptor && kind != null && VisibilityUtil.isInlineClassWrapperConstructor((FunctionDescriptor)memberDescriptor)) {
            return 2;
        }
        if (InlineOnlyKt.isInlineOnlyPrivateInBytecode(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == DescriptorVisibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return VisibilityUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return VisibilityUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod(), null);
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property2 = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor = method = memberDescriptor == property2.getGetter() ? ((SyntheticJavaPropertyDescriptor)property2).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property2).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property2;
            return VisibilityUtil.getVisibilityAccessFlag(method, null);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == DescriptorVisibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!DescriptorVisibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isEnumEntry(containingDeclaration)) {
            return 0;
        }
        return null;
    }

    private static boolean isNonIntrinsicPrivateCompanionObjectInInterface(@NotNull DeclarationDescriptorWithVisibility companionObject) {
        if (companionObject == null) {
            VisibilityUtil.$$$reportNull$$$0(6);
        }
        return DescriptorUtils.isCompanionObject(companionObject) && JvmCodegenUtil.isJvmInterface(companionObject.getContainingDeclaration()) && !DescriptorsJvmAbiUtil.isMappedIntrinsicCompanionObject((ClassDescriptor)companionObject) && DescriptorVisibilities.isPrivate(companionObject.getVisibility());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObject";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/asJava/classes/VisibilityUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlineClassWrapperConstructor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonCallableFlags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibilityAccessFlag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "specialCaseVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonIntrinsicPrivateCompanionObjectInInterface";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

