/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.konan;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.stubs.PsiFileStub;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.util.indexing.FileContent;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import ksp.org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import ksp.org.jetbrains.kotlin.analysis.decompiler.konan.NearFileClassDataFinder;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import ksp.org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import ksp.org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import ksp.org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import ksp.org.jetbrains.kotlin.serialization.deserialization.AnnotationLoader;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import ksp.org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import ksp.org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u001c\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/analysis/decompiler/konan/K2KlibMetadataStubBuilder;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "version", "", "fileType", "Lksp/com/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lksp/org/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function1;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "Lksp/org/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "<init>", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getStubVersion", "buildMetadataFileStub", "Lksp/com/intellij/psi/stubs/PsiFileStub;", "fileWithMetadata", "Lksp/org/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "fileContent", "Lksp/com/intellij/util/indexing/FileContent;", "decompiler-native"})
public final class K2KlibMetadataStubBuilder
extends KlibMetadataStubBuilder {
    private final int version;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;

    public K2KlibMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, (String)"readFile");
        super(version, fileType, readFile);
        this.version = version;
        this.serializerProtocol = serializerProtocol;
    }

    @Override
    public int getStubVersion() {
        return this.version;
    }

    @Override
    @NotNull
    protected PsiFileStub<?> buildMetadataFileStub(@NotNull FileWithMetadata.Compatible fileWithMetadata, @NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileWithMetadata, (String)"fileWithMetadata");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        ProtoBuf.Package packageProto = fileWithMetadata.getProto().getPackage();
        FqName packageFqName = fileWithMetadata.getPackageFqName();
        NameResolverImpl nameResolver = fileWithMetadata.getNameResolver();
        ProtoBasedClassDataFinder mainClassDataFinder = new ProtoBasedClassDataFinder(fileWithMetadata.getProto(), nameResolver, fileWithMetadata.getVersion(), null, 8, null);
        SerializerExtensionProtocol protocol = (SerializerExtensionProtocol)this.serializerProtocol.invoke();
        ClassDataFinder classDataFinder = mainClassDataFinder;
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        ClassDataFinder classDataFinder2 = NearFileClassDataFinder.Companion.wrapIfNeeded(classDataFinder, virtualFile, this.getReadFile());
        AnnotationLoader annotationLoader = new AnnotationLoaderForStubBuilderImpl(protocol);
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        ClsStubBuilderComponents components = new ClsStubBuilderComponents(classDataFinder2, annotationLoader, virtualFile2, protocol, null, null, 48, null);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
        Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
        ClsStubBuilderContext context2 = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
        StubElement stubElement = fileStub;
        ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, context2.getNameResolver(), context2.getTypeTable(), null);
        Intrinsics.checkNotNull((Object)packageProto);
        CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context2, package_, packageProto);
        for (ProtoBuf.Class classProto : fileWithMetadata.getClassesToDecompile()) {
            ClassClsStubBuilderKt.createClassStub(fileStub, classProto, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), null, context2);
        }
        return fileStub;
    }
}

