/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import ksp.org.jdom.Content;
import ksp.org.jdom.IllegalDataException;
import ksp.org.jdom.Parent;
import ksp.org.jdom.Text;
import ksp.org.jdom.Verifier;

public class CDATA
extends Text {
    private static final long serialVersionUID = 200L;

    protected CDATA() {
        super(Content.CType.CDATA);
    }

    public CDATA(String string) {
        super(Content.CType.CDATA);
        this.setText(string);
    }

    @Override
    public CDATA setText(String str) {
        if (str == null || "".equals(str)) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = str;
        return this;
    }

    @Override
    public void append(String str) {
        if (str == null || "".equals(str)) {
            return;
        }
        String tmpValue = this.value == "" ? str : this.value + str;
        String reason = Verifier.checkCDATASection(tmpValue);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = tmpValue;
    }

    @Override
    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.append(text.getText());
    }

    @Override
    public String toString() {
        return new StringBuilder(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }

    @Override
    public CDATA clone() {
        return (CDATA)super.clone();
    }

    @Override
    public CDATA detach() {
        return (CDATA)super.detach();
    }

    @Override
    protected CDATA setParent(Parent parent2) {
        return (CDATA)super.setParent(parent2);
    }
}

