/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import ksp.one.util.streamex.Internals;
import ksp.one.util.streamex.TailConcatSpliterator;
import ksp.one.util.streamex.UnknownSizeSpliterator;

class ZipSpliterator<U, V, R>
implements Spliterator<R> {
    private Spliterator<U> left;
    private Spliterator<V> right;
    private final BiFunction<? super U, ? super V, ? extends R> mapper;
    private boolean trySplit;
    private int batch = 0;
    private final Internals.Box<U> l = new Internals.Box();
    private final Internals.Box<V> r = new Internals.Box();

    ZipSpliterator(Spliterator<U> left, Spliterator<V> right, BiFunction<? super U, ? super V, ? extends R> mapper, boolean trySplit) {
        this.left = left;
        this.right = right;
        this.mapper = mapper;
        this.trySplit = trySplit;
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.left.tryAdvance(this.l) && this.right.tryAdvance(this.r)) {
            action.accept(this.mapper.apply(this.l.a, this.r.a));
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        long rightSize;
        if (!this.hasCharacteristics(64)) {
            Spliterator.super.forEachRemaining(action);
            return;
        }
        long leftSize = this.left.getExactSizeIfKnown();
        if (leftSize <= (rightSize = this.right.getExactSizeIfKnown())) {
            this.left.forEachRemaining((? super T u2) -> {
                if (this.right.tryAdvance(this.r)) {
                    action.accept((R)this.mapper.apply(u2, this.r.a));
                }
            });
        } else {
            this.right.forEachRemaining((? super T v2) -> {
                if (this.left.tryAdvance(this.l)) {
                    action.accept((R)this.mapper.apply(this.l.a, v2));
                }
            });
        }
    }

    @Override
    public Spliterator<R> trySplit() {
        if (this.trySplit && this.hasCharacteristics(16448)) {
            Spliterator<U> leftPrefix = this.left.trySplit();
            if (leftPrefix == null) {
                return this.arraySplit();
            }
            Spliterator<V> rightPrefix = this.right.trySplit();
            if (rightPrefix == null) {
                this.left = new TailConcatSpliterator<U>(leftPrefix, this.left);
                return this.arraySplit();
            }
            long leftSize = leftPrefix.getExactSizeIfKnown();
            long rightSize = rightPrefix.getExactSizeIfKnown();
            if (leftSize >= 0L && rightSize >= 0L) {
                if (leftSize == rightSize) {
                    return new ZipSpliterator<U, V, R>(leftPrefix, rightPrefix, this.mapper, true);
                }
                if (Math.abs(leftSize - rightSize) < Math.min(1024L, Math.max(leftSize, rightSize) / 8L)) {
                    if (leftSize < rightSize) {
                        Object[] array = new Object[(int)(rightSize - leftSize)];
                        Internals.drainTo(array, this.left);
                        leftPrefix = new TailConcatSpliterator<U>(leftPrefix, Spliterators.spliterator(array, this.characteristics()));
                    } else {
                        Object[] array = new Object[(int)(leftSize - rightSize)];
                        Internals.drainTo(array, this.right);
                        rightPrefix = new TailConcatSpliterator<V>(rightPrefix, Spliterators.spliterator(array, this.characteristics()));
                    }
                    this.trySplit = false;
                    return new ZipSpliterator<U, V, R>(leftPrefix, rightPrefix, this.mapper, false);
                }
            }
            this.left = new TailConcatSpliterator<U>(leftPrefix, this.left);
            this.right = new TailConcatSpliterator<V>(rightPrefix, this.right);
        }
        return this.arraySplit();
    }

    private Spliterator<R> arraySplit() {
        Object[] array;
        int index2;
        long s2 = this.estimateSize();
        if (s2 <= 1L) {
            return null;
        }
        int n2 = this.batch + 1024;
        if ((long)n2 > s2) {
            n2 = (int)s2;
        }
        if (n2 > 0x2000000) {
            n2 = 0x2000000;
        }
        if ((this.batch = (index2 = Internals.drainTo(array = new Object[n2], this))) == 0) {
            return null;
        }
        long s22 = this.estimateSize();
        UnknownSizeSpliterator.USOfRef prefix = new UnknownSizeSpliterator.USOfRef(array, 0, index2);
        prefix.est = this.hasCharacteristics(16384) ? (long)index2 : (s2 == s22 ? Math.max((long)index2, s2 / 2L) : Math.max((long)index2, s22 - s2));
        return prefix;
    }

    @Override
    public long estimateSize() {
        return Math.min(this.left.estimateSize(), this.right.estimateSize());
    }

    @Override
    public int characteristics() {
        return this.left.characteristics() & this.right.characteristics() & 0x5450;
    }
}

