/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.ArrayDeque;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ksp.one.util.streamex.Internals;

final class OrderedCancellableSpliterator<T, A>
extends Internals.CloneableSpliterator<A, OrderedCancellableSpliterator<T, A>> {
    private Spliterator<T> source;
    private final Object lock = new Object();
    private final BiConsumer<A, ? super T> accumulator;
    private final Predicate<A> cancelPredicate;
    private final BinaryOperator<A> combiner;
    private final Supplier<A> supplier;
    private volatile boolean localCancelled;
    private volatile OrderedCancellableSpliterator<T, A> prefix;
    private volatile OrderedCancellableSpliterator<T, A> suffix;
    private A payload;

    OrderedCancellableSpliterator(Spliterator<T> source, Supplier<A> supplier, BiConsumer<A, ? super T> accumulator, BinaryOperator<A> combiner, Predicate<A> cancelPredicate) {
        this.source = source;
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.cancelPredicate = cancelPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super A> action) {
        A acc;
        block16: {
            Spliterator<Object> source = this.source;
            if (source == null || this.localCancelled) {
                this.source = null;
                return false;
            }
            acc = this.supplier.get();
            try {
                source.forEachRemaining((? super T t2) -> {
                    this.accumulator.accept(acc, t2);
                    if (this.cancelPredicate.test(acc)) {
                        this.cancelSuffix();
                        throw new Internals.CancelException();
                    }
                    if (this.localCancelled) {
                        throw new Internals.CancelException();
                    }
                });
            }
            catch (Internals.CancelException ex) {
                if (!this.localCancelled) break block16;
                return false;
            }
        }
        this.source = null;
        Object result2 = acc;
        block5: while (true) {
            if (this.prefix == null && this.suffix == null) {
                action.accept(result2);
                return true;
            }
            ArrayDeque<A> res2 = new ArrayDeque<A>();
            res2.offer(result2);
            Object object = this.lock;
            synchronized (object) {
                if (this.localCancelled) {
                    return false;
                }
                OrderedCancellableSpliterator<T, A> s2 = this.prefix;
                while (s2 != null && s2.payload != null) {
                    res2.offerFirst(s2.payload);
                    s2 = s2.prefix;
                }
                this.prefix = s2;
                if (s2 != null) {
                    s2.suffix = this;
                }
                s2 = this.suffix;
                while (s2 != null && s2.payload != null) {
                    res2.offerLast(s2.payload);
                    s2 = s2.suffix;
                }
                this.suffix = s2;
                if (s2 != null) {
                    s2.prefix = this;
                }
                if (res2.size() == 1) {
                    if (this.prefix == null && this.suffix == null) {
                        action.accept(result2);
                        return true;
                    }
                    this.payload = result2;
                    break;
                }
            }
            result2 = res2.pollFirst();
            while (true) {
                if (res2.isEmpty()) continue block5;
                if (!this.cancelPredicate.test(result2 = this.combiner.apply(result2, res2.pollFirst()))) continue;
                this.cancelSuffix();
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSuffix() {
        if (this.suffix == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            OrderedCancellableSpliterator<T, A> suffix = this.suffix;
            while (suffix != null && !suffix.localCancelled) {
                suffix.prefix = null;
                suffix.localCancelled = true;
                suffix = suffix.suffix;
            }
            this.suffix = null;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super A> action) {
        this.tryAdvance(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<A> trySplit() {
        if (this.source == null || this.localCancelled) {
            this.source = null;
            return null;
        }
        Spliterator<T> prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            OrderedCancellableSpliterator result2 = (OrderedCancellableSpliterator)this.doClone();
            result2.source = prefix;
            this.prefix = result2;
            result2.suffix = this;
            OrderedCancellableSpliterator<T, A> prefixPrefix = result2.prefix;
            if (prefixPrefix != null) {
                prefixPrefix.suffix = result2;
            }
            return result2;
        }
    }

    @Override
    public long estimateSize() {
        return this.source == null ? 0L : this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source == null ? 64 : 16;
    }
}

