/*
 * Decompiled with CFR 0.152.
 */
package ksp.io.opentelemetry.api.trace;

import io.opentelemetry.context.Context;
import java.util.concurrent.TimeUnit;
import ksp.io.opentelemetry.api.common.AttributeKey;
import ksp.io.opentelemetry.api.common.Attributes;
import ksp.io.opentelemetry.api.internal.ApiUsageLogger;
import ksp.io.opentelemetry.api.trace.Span;
import ksp.io.opentelemetry.api.trace.SpanBuilder;
import ksp.io.opentelemetry.api.trace.SpanContext;
import ksp.io.opentelemetry.api.trace.SpanKind;
import ksp.io.opentelemetry.api.trace.Tracer;
import ksp.javax.annotation.Nullable;
import ksp.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultTracer
implements Tracer {
    private static final Tracer INSTANCE = new DefaultTracer();

    static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements SpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context2) {
            if (context2 == null) {
                ApiUsageLogger.log("context is null");
                return this;
            }
            this.spanContext = Span.fromContext(context2).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value2) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value2) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value2) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value2) {
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value2) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        private NoopSpanBuilder() {
        }
    }
}

