/*
 * Decompiled with CFR 0.152.
 */
package ksp.io.opentelemetry.api.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import ksp.io.opentelemetry.api.internal.ReadOnlyArrayMap;
import ksp.io.opentelemetry.api.internal.Utils;
import ksp.javax.annotation.Nullable;
import ksp.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ImmutableKeyValuePairs<K, V> {
    private final Object[] data;
    private int hashcode;

    protected ImmutableKeyValuePairs(Object[] data) {
        this.data = data;
    }

    protected ImmutableKeyValuePairs(Object[] data, Comparator<?> keyComparator) {
        this(ImmutableKeyValuePairs.sortAndFilter(data, keyComparator));
    }

    protected final List<Object> data() {
        return Arrays.asList(this.data);
    }

    public final int size() {
        return this.data.length / 2;
    }

    public final boolean isEmpty() {
        return this.data.length == 0;
    }

    public final Map<K, V> asMap() {
        return ReadOnlyArrayMap.wrap(this.data());
    }

    @Nullable
    public final V get(K key) {
        if (key == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            if (!key.equals(this.data[i2])) continue;
            return (V)this.data[i2 + 1];
        }
        return null;
    }

    public final void forEach(BiConsumer<? super K, ? super V> consumer2) {
        if (consumer2 == null) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            consumer2.accept(this.data[i2], this.data[i2 + 1]);
        }
    }

    private static Object[] sortAndFilter(Object[] data, Comparator<?> keyComparator) {
        Utils.checkArgument(data.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        if (data.length == 0) {
            return data;
        }
        ImmutableKeyValuePairs.mergeSort(data, keyComparator);
        return ImmutableKeyValuePairs.dedupe(data, keyComparator);
    }

    private static void mergeSort(Object[] data, Comparator<?> keyComparator) {
        Object[] workArray = new Object[data.length];
        System.arraycopy(data, 0, workArray, 0, data.length);
        ImmutableKeyValuePairs.splitAndMerge(workArray, 0, data.length, data, keyComparator);
    }

    private static void splitAndMerge(Object[] workArray, int beginIndex, int endIndex, Object[] targetArray, Comparator<?> keyComparator) {
        if (endIndex - beginIndex <= 2) {
            return;
        }
        int midpoint = (endIndex + beginIndex) / 4 * 2;
        ImmutableKeyValuePairs.splitAndMerge(targetArray, beginIndex, midpoint, workArray, keyComparator);
        ImmutableKeyValuePairs.splitAndMerge(targetArray, midpoint, endIndex, workArray, keyComparator);
        ImmutableKeyValuePairs.merge(workArray, beginIndex, midpoint, endIndex, targetArray, keyComparator);
    }

    private static <K> void merge(Object[] sourceArray, int beginIndex, int middleIndex, int endIndex, Object[] targetArray, Comparator<K> keyComparator) {
        int leftKeyIndex = beginIndex;
        int rightKeyIndex = middleIndex;
        for (int k2 = beginIndex; k2 < endIndex; k2 += 2) {
            if (leftKeyIndex < middleIndex - 1 && (rightKeyIndex >= endIndex - 1 || ImmutableKeyValuePairs.compareToNullSafe(sourceArray[leftKeyIndex], sourceArray[rightKeyIndex], keyComparator) <= 0)) {
                targetArray[k2] = sourceArray[leftKeyIndex];
                targetArray[k2 + 1] = sourceArray[leftKeyIndex + 1];
                leftKeyIndex += 2;
                continue;
            }
            targetArray[k2] = sourceArray[rightKeyIndex];
            targetArray[k2 + 1] = sourceArray[rightKeyIndex + 1];
            rightKeyIndex += 2;
        }
    }

    private static <K> int compareToNullSafe(@Nullable K key, @Nullable K pivotKey, Comparator<K> keyComparator) {
        if (key == null) {
            return pivotKey == null ? 0 : -1;
        }
        if (pivotKey == null) {
            return 1;
        }
        return keyComparator.compare(key, pivotKey);
    }

    private static <K> Object[] dedupe(Object[] data, Comparator<K> keyComparator) {
        Object previousKey = null;
        int size = 0;
        for (int i2 = 0; i2 < data.length; i2 += 2) {
            Object key = data[i2];
            Object value2 = data[i2 + 1];
            if (key == null) continue;
            if (previousKey != null && keyComparator.compare(key, previousKey) == 0) {
                size -= 2;
            }
            if (value2 == null) {
                previousKey = null;
                continue;
            }
            previousKey = key;
            data[size++] = key;
            data[size++] = value2;
        }
        if (data.length != size) {
            Object[] result2 = new Object[size];
            System.arraycopy(data, 0, result2, 0, size);
            return result2;
        }
        return data;
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ImmutableKeyValuePairs)) {
            return false;
        }
        ImmutableKeyValuePairs that = (ImmutableKeyValuePairs)o2;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result2 = this.hashcode;
        if (result2 == 0) {
            result2 = 1;
            result2 *= 1000003;
            this.hashcode = result2 ^= Arrays.hashCode(this.data);
        }
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object value2 = this.data[i2 + 1];
            String valueStr = value2 instanceof String ? '\"' + (String)value2 + '\"' : value2.toString();
            sb.append(this.data[i2]).append("=").append(valueStr).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

