/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.util.function.IntUnaryOperator;
import ksp.com.intellij.psi.stubs.StrippedIntOpenHashMap;
import ksp.com.intellij.util.containers.UnsignedShortArrayList;

final class MostlyUShortIntList
implements IntUnaryOperator {
    private static final int IN_MAP = 65535;
    private final UnsignedShortArrayList myList;
    private StrippedIntOpenHashMap myMap;

    MostlyUShortIntList(int initialCapacity) {
        this.myList = new UnsignedShortArrayList(initialCapacity);
    }

    void add(int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(this.myList.size(), value2);
            value2 = 65535;
        }
        this.myList.add(value2);
    }

    void set(int index2, int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(index2, value2);
            value2 = 65535;
        }
        this.myList.setQuick(index2, value2);
    }

    private StrippedIntOpenHashMap initMap() {
        if (this.myMap == null) {
            this.myMap = new StrippedIntOpenHashMap();
        }
        return this.myMap;
    }

    @Override
    public int applyAsInt(int index2) {
        return this.get(index2);
    }

    public int get(int index2) {
        int value2 = this.myList.getQuick(index2);
        return value2 == 65535 ? this.myMap.get(index2, 0) : value2;
    }

    int size() {
        return this.myList.size();
    }

    void trimToSize() {
        this.myList.trimToSize();
    }
}

