/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ksp.com.intellij.injected.editor.VirtualFileWindow;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageExtension;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.components.Service;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.LanguageSubstitutor;
import ksp.com.intellij.util.FileContentUtilCore;
import ksp.com.intellij.util.ObjectUtils;
import ksp.org.jetbrains.annotations.NotNull;

@Service
public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<String>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create("PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final AtomicBoolean REQUESTS_DRAIN_NEEDED = new AtomicBoolean(true);
    private static final ConcurrentMap<VirtualFile, SubstitutionInfo> ourReparsingRequests = new ConcurrentHashMap<VirtualFile, SubstitutionInfo>();

    @NotNull
    public static LanguageSubstitutors getInstance() {
        LanguageSubstitutors languageSubstitutors = ApplicationManager.getApplication().getService(LanguageSubstitutors.class);
        if (languageSubstitutors == null) {
            LanguageSubstitutors.$$$reportNull$$$0(0);
        }
        return languageSubstitutors;
    }

    private LanguageSubstitutors() {
        super("ksp.com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language originalLang, @NotNull VirtualFile file, @NotNull Project project) {
        if (originalLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(1);
        }
        if (file == null) {
            LanguageSubstitutors.$$$reportNull$$$0(2);
        }
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(3);
        }
        for (LanguageSubstitutor substitutor2 : this.forKey(originalLang)) {
            Language substitutedLang = substitutor2.getLanguage(file, project);
            if (substitutedLang == null) continue;
            if (substitutedLang == Language.ANY) {
                LOG.error("For " + originalLang + " and " + file + ", " + substitutor2.getClass().getName() + " returned Language.ANY, which is not allowed");
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("For " + originalLang + " and " + file + ", " + substitutor2.getClass().getName() + " returned '" + substitutedLang + "' of " + substitutedLang.getClass());
            }
            LanguageSubstitutors.processLanguageSubstitution(file, originalLang, substitutedLang, project);
            Language language = substitutedLang;
            if (language == null) {
                LanguageSubstitutors.$$$reportNull$$$0(4);
            }
            return language;
        }
        Language language = originalLang;
        if (language == null) {
            LanguageSubstitutors.$$$reportNull$$$0(5);
        }
        return language;
    }

    private static void processLanguageSubstitution(@NotNull VirtualFile file, @NotNull Language originalLang, @NotNull Language substitutedLang, @NotNull Project project) {
        if (file == null) {
            LanguageSubstitutors.$$$reportNull$$$0(6);
        }
        if (originalLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(7);
        }
        if (substitutedLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(8);
        }
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(9);
        }
        if (file instanceof VirtualFileWindow) {
            return;
        }
        Key<String> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = Language.findLanguageByID(projectKey.get(file));
        Language prevLang = ObjectUtils.notNull(prevSubstitutedLang, originalLang);
        if (!prevLang.is(substitutedLang) && file.replace(projectKey, prevSubstitutedLang != null ? prevSubstitutedLang.getID() : null, substitutedLang.getID())) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            LanguageSubstitutors.requestReparsing(file, prevLang, substitutedLang);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<String> getOrCreateProjectKey(@NotNull Project project) {
        Key<String> key;
        if (project == null) {
            LanguageSubstitutors.$$$reportNull$$$0(10);
        }
        if ((key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project)) == null) {
            Key<Key<String>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set(project, key);
                }
            }
        }
        Key<String> key3 = key;
        if (key3 == null) {
            LanguageSubstitutors.$$$reportNull$$$0(11);
        }
        return key3;
    }

    private static void requestReparsing(@NotNull VirtualFile file, @NotNull Language prevLang, @NotNull Language substitutedLang) {
        if (file == null) {
            LanguageSubstitutors.$$$reportNull$$$0(12);
        }
        if (prevLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(13);
        }
        if (substitutedLang == null) {
            LanguageSubstitutors.$$$reportNull$$$0(14);
        }
        ourReparsingRequests.put(file, new SubstitutionInfo(prevLang, substitutedLang));
        if (REQUESTS_DRAIN_NEEDED.compareAndSet(true, false)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                REQUESTS_DRAIN_NEEDED.set(true);
                ArrayList set = new ArrayList(ourReparsingRequests.entrySet());
                ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(set.size());
                int id = 1;
                for (Map.Entry entry : set) {
                    VirtualFile f2 = (VirtualFile)entry.getKey();
                    SubstitutionInfo info = (SubstitutionInfo)entry.getValue();
                    ourReparsingRequests.remove(f2);
                    if (!f2.isValid()) continue;
                    LOG.info("Reparsing " + f2.getPath() + " because of language substitution " + info.myPrevLang.getID() + "->" + info.mySubstitutedLang.getID() + ", #" + id++);
                    files2.add(f2);
                }
                if (files2.size() > 0) {
                    FileContentUtilCore.reparseFiles(files2);
                }
            });
        }
    }

    public static void cancelReparsing(@NotNull VirtualFile file) {
        if (file == null) {
            LanguageSubstitutors.$$$reportNull$$$0(15);
        }
        ourReparsingRequests.remove(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/LanguageSubstitutors";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLang";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedLang";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevLang";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/LanguageSubstitutors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectKey";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processLanguageSubstitution";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectKey";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requestReparsing";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cancelReparsing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubstitutionInfo {
        private final Language myPrevLang;
        private final Language mySubstitutedLang;

        SubstitutionInfo(@NotNull Language prevLang, @NotNull Language substitutedLang) {
            if (prevLang == null) {
                SubstitutionInfo.$$$reportNull$$$0(0);
            }
            if (substitutedLang == null) {
                SubstitutionInfo.$$$reportNull$$$0(1);
            }
            this.myPrevLang = prevLang;
            this.mySubstitutedLang = substitutedLang;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prevLang";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutedLang";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/psi/LanguageSubstitutors$SubstitutionInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

