/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipFile;
import ksp.com.intellij.openapi.vfs.impl.ZipHandlerBase;
import ksp.com.intellij.util.io.FileAccessorCache;
import ksp.com.intellij.util.io.ResourceHandle;
import ksp.org.jetbrains.annotations.NotNull;

public class ZipHandler
extends ZipHandlerBase {
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        @NotNull
        protected ZipFile createAccessor(ZipHandler handler2) throws IOException {
            File file = handler2.getFile();
            BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            handler2.myFileStamp = attrs.lastModifiedTime().toMillis();
            handler2.myFileLength = attrs.size();
            return new ZipFile(file);
        }

        @Override
        protected void disposeAccessor(@NotNull ZipFile fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(0);
            }
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "ksp/com/intellij/openapi/vfs/impl/ZipHandler$1", "disposeAccessor"));
        }
    };
    private volatile long myFileStamp;
    private volatile long myFileLength;

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle<ZipFile> handle;
        try {
            FileAccessorCache.Handle<ZipFile> handle2 = ourZipFileFileAccessorCache.get(this);
            File file = this.getFile();
            BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (attrs.lastModifiedTime().toMillis() != this.myFileStamp || attrs.size() != this.myFileLength) {
                this.clearCaches();
                handle2.release();
                handle2 = ourZipFileFileAccessorCache.get(this);
            }
            handle = handle2;
        }
        catch (RuntimeException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e2;
        }
        if (handle == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        return handle;
    }

    @Override
    public void clearCaches() {
        ourZipFileFileAccessorCache.remove(this);
        super.clearCaches();
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

