/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.openapi.vfs.impl.LightFilePointerKt;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/com/intellij/openapi/vfs/impl/LightFilePointer;", "Lksp/com/intellij/openapi/vfs/pointers/VirtualFilePointer;", "url", "", "(Ljava/lang/String;)V", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "cachedFile", "isRefreshed", "", "equals", "other", "", "getFile", "getFileName", "getPresentableUrl", "getUrl", "hashCode", "", "isValid", "refreshFile", "", "intellij.platform.core.impl"})
public class LightFilePointer
implements VirtualFilePointer {
    @NotNull
    private final String url;
    @Nullable
    private volatile VirtualFile cachedFile;
    private volatile boolean isRefreshed;

    public LightFilePointer(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    public LightFilePointer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        this.url = string;
        this.cachedFile = file;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.cachedFile;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string;
        VirtualFile virtualFile = this.cachedFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }
        int index2 = StringsKt.lastIndexOf$default((CharSequence)this.url, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index2 >= 0) {
            String string3 = this.url.substring(index2 + 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = this.url;
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        VirtualFile virtualFile = this.getFile();
        String string = virtualFile != null ? virtualFile.getPresentableUrl() : null;
        if (string == null) {
            string = LightFilePointerKt.access$toPresentableUrl(this.url);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.getFile() != null;
    }

    private final void refreshFile() {
        VirtualFile virtualFile = this.cachedFile;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            if (it.isValid()) {
                return;
            }
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        VirtualFile virtualFile2 = virtualFileManager2.findFileByUrl(this.url);
        if (virtualFile2 == null && !this.isRefreshed) {
            this.isRefreshed = true;
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread() || !app.isReadAccessAllowed()) {
                virtualFile2 = virtualFileManager2.refreshAndFindFileByUrl(this.url);
            } else {
                app.executeOnPooledThread(() -> LightFilePointer.refreshFile$lambda$2(virtualFileManager2, this));
            }
        }
        this.cachedFile = virtualFile2 != null && virtualFile2.isValid() ? virtualFile2 : null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LightFilePointer ? Intrinsics.areEqual((Object)this.url, (Object)((LightFilePointer)other).url) : false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    private static final void refreshFile$lambda$2(VirtualFileManager $virtualFileManager, LightFilePointer this$0) {
        Intrinsics.checkNotNullParameter((Object)$virtualFileManager, (String)"$virtualFileManager");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $virtualFileManager.refreshAndFindFileByUrl(this$0.url);
    }
}

