/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress;

import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.progress.Cancellation;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class EmptyProgressIndicatorBase
implements ProgressIndicator {
    @NotNull
    private final ModalityState myModalityState;
    @NotNull
    private volatile RunState myRunState;
    private volatile int myNonCancelableSectionCount;

    @ApiStatus.Obsolete
    public EmptyProgressIndicatorBase() {
        this(ModalityState.defaultModalityState());
    }

    @ApiStatus.Obsolete
    public EmptyProgressIndicatorBase(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            EmptyProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        this.myRunState = RunState.VIRGIN;
        this.myModalityState = modalityState;
    }

    @Override
    public void start() {
        if (this.myRunState == RunState.STARTED) {
            throw new IllegalStateException("Indicator already started");
        }
        this.myRunState = RunState.STARTED;
    }

    @Override
    public void stop() {
        switch (this.myRunState) {
            case VIRGIN: {
                throw new IllegalStateException("Indicator can't be stopped because it wasn't started");
            }
            case STARTED: {
                this.myRunState = RunState.STOPPED;
                break;
            }
            case STOPPED: {
                throw new IllegalStateException("Indicator already stopped");
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunState == RunState.STARTED;
    }

    @Override
    public final void checkCanceled() {
        if (this.isCanceled() && this.myNonCancelableSectionCount == 0 && !Cancellation.isInNonCancelableSection()) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText2(String text) {
    }

    @Override
    public String getText2() {
        return "";
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    @Override
    public void setFraction(double fraction) {
    }

    @Override
    public void pushState() {
    }

    @Override
    public void popState() {
    }

    @Override
    public void startNonCancelableSection() {
        PluginException.reportDeprecatedUsage("ProgressIndicator#startNonCancelableSection", "Use `ProgressManager.executeNonCancelableSection()` instead");
        ++this.myNonCancelableSectionCount;
    }

    @Override
    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            EmptyProgressIndicatorBase.$$$reportNull$$$0(1);
        }
        return modalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
        if (this.isRunning()) {
            throw new IllegalStateException("Can't change modality progress for already running indicator");
        }
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public boolean isPopupWasShown() {
        return false;
    }

    @Override
    public boolean isShowing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/EmptyProgressIndicatorBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/EmptyProgressIndicatorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RunState {
        VIRGIN,
        STARTED,
        STOPPED;

    }
}

