/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.fileTypes;

import java.util.function.Supplier;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.util.io.ByteSequence;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    private static Supplier<? extends FileTypeRegistry> instanceGetter;

    @ApiStatus.Internal
    public static Supplier<? extends FileTypeRegistry> setInstanceSupplier(@NotNull Supplier<? extends FileTypeRegistry> supplier) {
        if (supplier == null) {
            FileTypeRegistry.$$$reportNull$$$0(0);
        }
        Supplier<? extends FileTypeRegistry> oldValue = instanceGetter;
        instanceGetter = supplier;
        return oldValue;
    }

    @ApiStatus.Internal
    public static boolean isInstanceSupplierSet() {
        return instanceGetter != null;
    }

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type2) {
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            FileTypeRegistry.$$$reportNull$$$0(2);
        }
        return file.getFileType() == type2;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        if (language == null) {
            FileTypeRegistry.$$$reportNull$$$0(3);
        }
        return language.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        Supplier<? extends FileTypeRegistry> instanceGetter = FileTypeRegistry.instanceGetter;
        if (instanceGetter == null) {
            return (FileTypeRegistry)ApplicationManager.getApplication().getServiceByClassName("ksp.com.intellij.openapi.fileTypes.FileTypeManager");
        }
        return instanceGetter.get();
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file, byte @Nullable [] content) {
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(4);
        }
        FileType fileType = this.getFileTypeByFile(file);
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(5);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileNameSeq) {
        if (fileNameSeq == null) {
            FileTypeRegistry.$$$reportNull$$$0(6);
        }
        FileType fileType = this.getFileTypeByFileName(fileNameSeq.toString());
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(7);
        }
        return fileType;
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NotNull String var1);

    public abstract FileType findFileTypeByName(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSeq";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInstanceSupplier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileTypeDetector {
        public static final ExtensionPointName<FileTypeDetector> EP_NAME = new ExtensionPointName("ksp.com.intellij.fileTypeDetector");

        @Nullable
        public FileType detect(@NotNull VirtualFile var1, @NotNull ByteSequence var2, @Nullable CharSequence var3);

        default public int getDesiredContentPrefixLength() {
            return 1024;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        default public int getVersion() {
            return 0;
        }
    }
}

