/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptor;
import ksp.com.intellij.ide.plugins.PluginEnabler;
import ksp.com.intellij.ide.plugins.PluginManagerCore;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.kotlinx.collections.immutable.ExtensionsKt;
import ksp.kotlinx.collections.immutable.PersistentSet;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0002\u001a$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\rH\u0002\u001a\"\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0007\"\u001a\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"(\u0010\u0006\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"LOG", "Lksp/com/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "()V", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "brokenPluginVersions", "Ljava/lang/ref/Reference;", "", "Lksp/com/intellij/openapi/extensions/PluginId;", "", "", "updatedBrokenPluginFile", "Ljava/nio/file/Path;", "getUpdatedBrokenPluginFile", "()Ljava/nio/file/Path;", "getBrokenPluginVersions", "isBrokenPlugin", "", "descriptor", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptor;", "readBrokenPluginFile", "tryReadBrokenPluginsFile", "brokenPluginsStorage", "updateBrokenPlugins", "", "brokenPlugins", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nbrokenPluginFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,129:1\n31#2:130\n*S KotlinDebug\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n*L\n114#1:130\n*E\n"})
public final class BrokenPluginFileKt {
    @Nullable
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;

    private static final Logger getLOG() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    private static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    public static final Path getUpdatedBrokenPluginFile() {
        String[] stringArray = new String[]{"updatedBrokenPlugins.db"};
        Path path = Paths.get(PathManager.getConfigPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @ApiStatus.Internal
    public static final boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PluginId pluginId = descriptor2.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId pluginId2 = pluginId;
        Set<String> set = BrokenPluginFileKt.getBrokenPluginVersions().get(pluginId2);
        return set != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    public static final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2;
        if (PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            return MapsKt.emptyMap();
        }
        Reference<Map<PluginId, Set<String>>> reference2 = brokenPluginVersions;
        Map<PluginId, Set<String>> map = result2 = reference2 != null ? reference2.get() : null;
        if (result2 == null) {
            result2 = BrokenPluginFileKt.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final void updateBrokenPlugins(@NotNull Map<PluginId, ? extends Set<String>> brokenPlugins) {
        Intrinsics.checkNotNullParameter(brokenPlugins, (String)"brokenPlugins");
        brokenPluginVersions = new SoftReference<Map<PluginId, ? extends Set<String>>>(brokenPlugins);
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile();
        try {
            Closeable closeable = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));
            Throwable throwable = null;
            try {
                DataOutputStream out = (DataOutputStream)closeable;
                boolean bl2 = false;
                out.write(2);
                out.writeUTF(PluginManagerCore.getBuildNumber().asString());
                out.writeInt(brokenPlugins.size());
                for (Map.Entry<PluginId, ? extends Set<String>> entry : brokenPlugins.entrySet()) {
                    PluginId key = entry.getKey();
                    Set<String> value2 = entry.getValue();
                    out.writeUTF(key.getIdString());
                    out.writeShort(value2.size());
                    for (String s2 : value2) {
                        out.writeUTF(s2);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e2) {
            BrokenPluginFileKt.getLOG().error("Failed to write " + updatedBrokenPluginFile, e2);
        }
    }

    private static final Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> map;
        Map<PluginId, Set<String>> result2 = null;
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            BrokenPluginFileKt.getLOG().info("Using cached broken plugins file");
        }
        if (result2 == null) {
            String[] stringArray = new String[]{"brokenPlugins.db"};
            Path path = Paths.get(PathManager.getBinPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            result2 = BrokenPluginFileKt.tryReadBrokenPluginsFile(path);
            if (result2 != null) {
                BrokenPluginFileKt.getLOG().info("Using broken plugins file from IDE distribution");
            }
        }
        if ((map = result2) == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try {
            Closeable closeable = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));
            Throwable throwable = null;
            try {
                DataInputStream stream = (DataInputStream)closeable;
                boolean bl2 = false;
                int version = stream.readUnsignedByte();
                if (version != 2) {
                    BrokenPluginFileKt.getLOG().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version + ", supportedVersion=2)");
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                String buildNumber = stream.readUTF();
                if (!Intrinsics.areEqual((Object)buildNumber, (Object)PluginManagerCore.getBuildNumber().toString())) {
                    BrokenPluginFileKt.getLOG().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ')');
                    Map<PluginId, Set<String>> map = null;
                    return map;
                }
                int count = stream.readInt();
                HashMap result2 = new HashMap(count);
                for (int i2 = 0; i2 < count; ++i2) {
                    PluginId pluginId;
                    Intrinsics.checkNotNullExpressionValue((Object)PluginId.getId(stream.readUTF()), (String)"getId(...)");
                    PersistentSet $this$mutate$iv = ExtensionsKt.persistentHashSetOf();
                    boolean $i$f$mutate = false;
                    PersistentSet.Builder builder2 = $this$mutate$iv.builder();
                    Set set = builder2;
                    PluginId pluginId2 = pluginId;
                    HashMap hashMap = result2;
                    boolean bl3 = false;
                    int n2 = stream.readUnsignedShort();
                    int n3 = 0;
                    while (n3 < n2) {
                        void r2;
                        int it = n3++;
                        boolean bl4 = false;
                        String string = stream.readUTF();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                        r2.add(string);
                    }
                    Unit unit = Unit.INSTANCE;
                    hashMap.put(pluginId2, builder2.build());
                }
                Map map = result2;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e2) {
            BrokenPluginFileKt.getLOG().warn("Failed to read " + brokenPluginsStorage, e2);
        }
        return null;
    }
}

