/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.annotations.GwtIncompatible;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.ParametricNullness;
import ksp.com.google.common.collect.Platform;
import ksp.com.google.errorprone.annotations.CanIgnoreReturnValue;
import ksp.org.checkerframework.checker.nullness.qual.NonNull;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<@NonNull T> type2, int length) {
        return (Object[])Array.newInstance(type2, length);
    }

    public static <T> T[] newArray(T[] reference2, int length) {
        return Platform.newArray(reference2, length);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] first, T[] second, Class<@NonNull T> type2) {
        T[] result2 = ObjectArrays.newArray(type2, first.length + second.length);
        System.arraycopy(first, 0, result2, 0, first.length);
        System.arraycopy(second, 0, result2, first.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@ParametricNullness T element2, T[] array) {
        T[] result2 = ObjectArrays.newArray(array, array.length + 1);
        result2[0] = element2;
        System.arraycopy(array, 0, result2, 1, array.length);
        return result2;
    }

    public static <T> T[] concat(T[] array, @ParametricNullness T element2) {
        T[] result2 = Arrays.copyOf(array, array.length + 1);
        result2[array.length] = element2;
        return result2;
    }

    static <T> T[] toArrayImpl(Collection<?> c2, T[] array) {
        int size = c2.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        }
        ObjectArrays.fillArray(c2, array);
        if (array.length > size) {
            @Nullable T[] unsoundlyCovariantArray = array;
            unsoundlyCovariantArray[size] = null;
        }
        return array;
    }

    static <T> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c2) {
        return ObjectArrays.fillArray(c2, new Object[c2.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result2 = new Object[length];
        System.arraycopy(elements, offset, result2, 0, length);
        return result2;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array) {
        int i2 = 0;
        for (Object element2 : elements) {
            array[i2++] = element2;
        }
        return array;
    }

    static void swap(Object[] array, int i2, int j2) {
        Object temp = array[i2];
        array[i2] = array[j2];
        array[j2] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            ObjectArrays.checkElementNotNull(array[i2], i2);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element2, int index2) {
        if (element2 == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element2;
    }
}

