/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import ksp.com.google.common.collect.ImmutableMap;
import ksp.com.google.common.collect.Lists;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import ksp.org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import ksp.org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtIfExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtPostfixExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtTypeArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.KtWhenEntry;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.psi.LambdaArgument;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingContextUtils;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.CallResolver;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import ksp.org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.OldResolutionCandidate;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.storage.StorageManager;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;
import ksp.org.jetbrains.kotlin.types.TypeProjectionImpl;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ControlStructureTypingUtils {
    private static final Logger LOG = Logger.getInstance(ControlStructureTypingUtils.class);
    private final CallResolver callResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final ModuleDescriptor moduleDescriptor;
    private final StorageManager storageManager;

    public ControlStructureTypingUtils(@NotNull CallResolver callResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        if (callResolver == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(0);
        }
        if (dataFlowAnalyzer2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(1);
        }
        if (moduleDescriptor == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(2);
        }
        if (storageManager == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(3);
        }
        this.callResolver = callResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.moduleDescriptor = moduleDescriptor;
        this.storageManager = storageManager;
    }

    ResolvedCall<FunctionDescriptor> resolveSpecialConstructionAsCall(@NotNull Call call2, @NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable, @NotNull ExpressionTypingContext context2, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(4);
        }
        if (construct == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(5);
        }
        if (argumentNames == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(6);
        }
        if (isArgumentNullable == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(8);
        }
        SimpleFunctionDescriptorImpl function2 = this.createFunctionDescriptorForSpecialConstruction(construct, argumentNames, isArgumentNullable);
        return this.resolveSpecialConstructionAsCall(call2, function2, construct, context2, dataFlowInfoForArguments);
    }

    ResolvedCall<FunctionDescriptor> resolveTryAsCall(@NotNull Call call2, @NotNull List<Pair<KtExpression, VariableDescriptor>> catchedExceptions, @NotNull ExpressionTypingContext context2, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(9);
        }
        if (catchedExceptions == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(11);
        }
        ArrayList<String> argumentNames = Lists.newArrayList("tryBlock");
        ArrayList<Boolean> argumentsNullability = Lists.newArrayList(false);
        int counter = 0;
        for (Pair<KtExpression, VariableDescriptor> descriptorPair : catchedExceptions) {
            argumentNames.add("catchBlock" + counter);
            argumentsNullability.add(false);
            KtExpression catchBlock = (KtExpression)descriptorPair.getFirst();
            VariableDescriptor catchedExceptionDescriptor = (VariableDescriptor)descriptorPair.getSecond();
            context2.trace.record(BindingContext.NEW_INFERENCE_CATCH_EXCEPTION_PARAMETER, catchBlock, Ref.create(catchedExceptionDescriptor));
            ++counter;
        }
        SimpleFunctionDescriptorImpl function2 = this.createFunctionDescriptorForSpecialConstruction(ResolveConstruct.TRY, argumentNames, argumentsNullability);
        return this.resolveSpecialConstructionAsCall(call2, function2, ResolveConstruct.TRY, context2, dataFlowInfoForArguments);
    }

    private ResolvedCall<FunctionDescriptor> resolveSpecialConstructionAsCall(@NotNull Call call2, @NotNull SimpleFunctionDescriptorImpl function2, @NotNull ResolveConstruct construct, @NotNull ExpressionTypingContext context2, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(12);
        }
        if (function2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(13);
        }
        if (construct == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(15);
        }
        TracingStrategy tracing = this.createTracingForSpecialConstruction(call2, construct.getName(), context2);
        TypeSubstitutor knownTypeParameterSubstitutor = ControlStructureTypingUtils.createKnownTypeParameterSubstitutorForSpecialCall(construct, function2, context2.expectedType, context2.languageVersionSettings);
        OldResolutionCandidate<FunctionDescriptor> resolutionCandidate = OldResolutionCandidate.create(call2, function2, knownTypeParameterSubstitutor);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCallWithKnownCandidate(call2, tracing, context2, resolutionCandidate, dataFlowInfoForArguments);
        assert (results.isSingleResult()) : "Not single result after resolving one known candidate";
        return results.getResultingCall();
    }

    @Nullable
    private static TypeSubstitutor createKnownTypeParameterSubstitutorForSpecialCall(@NotNull ResolveConstruct construct, @NotNull SimpleFunctionDescriptorImpl function2, @NotNull KotlinType expectedType, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (construct == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(16);
        }
        if (function2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(17);
        }
        if (expectedType == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(18);
        }
        if (languageVersionSettings == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(19);
        }
        if (construct == ResolveConstruct.ELVIS || TypeUtils.noExpectedType(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType) || KotlinBuiltIns.isUnitOrNullableUnit(expectedType) || KotlinBuiltIns.isAnyOrNullableAny(expectedType)) {
            return null;
        }
        TypeConstructor typeParameterConstructor = function2.getTypeParameters().get(0).getTypeConstructor();
        TypeProjectionImpl typeProjection = new TypeProjectionImpl(expectedType);
        return TypeSubstitutor.create(ImmutableMap.of(typeParameterConstructor, typeProjection));
    }

    private SimpleFunctionDescriptorImpl createFunctionDescriptorForSpecialConstruction(@NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable) {
        if (construct == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(20);
        }
        if (argumentNames == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(21);
        }
        if (isArgumentNullable == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(22);
        }
        return ControlStructureTypingUtils.createFunctionDescriptorForSpecialConstruction(construct, argumentNames, isArgumentNullable, this.moduleDescriptor, this.storageManager);
    }

    public static SimpleFunctionDescriptorImpl createFunctionDescriptorForSpecialConstruction(@NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable, @NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        if (construct == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(23);
        }
        if (argumentNames == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(24);
        }
        if (isArgumentNullable == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(25);
        }
        if (moduleDescriptor == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(26);
        }
        if (storageManager == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(27);
        }
        assert (argumentNames.size() == isArgumentNullable.size());
        SimpleFunctionDescriptorImpl function2 = SimpleFunctionDescriptorImpl.create(moduleDescriptor, Annotations.Companion.getEMPTY(), construct.getSpecialFunctionName(), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        TypeParameterDescriptor typeParameter = TypeParameterDescriptorImpl.createWithDefaultBound(function2, Annotations.Companion.getEMPTY(), false, Variance.INVARIANT, construct.getSpecialTypeParameterName(), 0, storageManager);
        SimpleType type2 = typeParameter.getDefaultType();
        KotlinType nullableType = TypeUtils.makeNullable(type2);
        ArrayList<ValueParameterDescriptorImpl> valueParameters = new ArrayList<ValueParameterDescriptorImpl>(argumentNames.size());
        for (int i2 = 0; i2 < argumentNames.size(); ++i2) {
            KotlinType argumentType = isArgumentNullable.get(i2) != false ? nullableType : type2;
            ValueParameterDescriptorImpl valueParameter2 = new ValueParameterDescriptorImpl(function2, null, i2, Annotations.Companion.getEMPTY(), Name.identifier(argumentNames.get(i2)), argumentType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters.add(valueParameter2);
        }
        SimpleType returnType2 = construct != ResolveConstruct.ELVIS ? type2 : TypeUtilsKt.replaceAnnotations(type2, AnnotationsForResolveUtilsKt.getExactInAnnotations());
        function2.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Lists.newArrayList(typeParameter), valueParameters, (KotlinType)returnType2, Modality.FINAL, DescriptorVisibilities.PUBLIC);
        return function2;
    }

    private static MutableDataFlowInfoForArguments createIndependentDataFlowInfoForArgumentsForCall(@NotNull DataFlowInfo initialDataFlowInfo, @NotNull Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap) {
        if (initialDataFlowInfo == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(28);
        }
        if (dataFlowInfoForArgumentsMap == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(29);
        }
        return new ControlStructureDataFlowInfo(initialDataFlowInfo, dataFlowInfoForArgumentsMap);
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsForIfCall(@NotNull Call callForIf, @NotNull DataFlowInfo conditionInfo, @NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
        if (callForIf == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(30);
        }
        if (conditionInfo == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(31);
        }
        if (thenInfo == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(32);
        }
        if (elseInfo == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(33);
        }
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = new HashMap<ValueArgument, DataFlowInfo>();
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(0), thenInfo);
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(1), elseInfo);
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(conditionInfo, dataFlowInfoForArgumentsMap);
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsOfWhenCall(@NotNull Call callForWhen, @NotNull DataFlowInfo subjectDataFlowInfo, @NotNull List<DataFlowInfo> entryDataFlowInfos) {
        if (callForWhen == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(34);
        }
        if (subjectDataFlowInfo == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(35);
        }
        if (entryDataFlowInfos == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(36);
        }
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = new HashMap<ValueArgument, DataFlowInfo>();
        int i2 = 0;
        for (ValueArgument valueArgument : callForWhen.getValueArguments()) {
            DataFlowInfo entryDataFlowInfo = entryDataFlowInfos.get(i2++);
            dataFlowInfoForArgumentsMap.put(valueArgument, entryDataFlowInfo);
        }
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(subjectDataFlowInfo, dataFlowInfoForArgumentsMap);
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsOfTryCall(@NotNull Call callForTry, @NotNull DataFlowInfo dataFlowInfoBeforeTry, @NotNull DataFlowInfo dataFlowInfoAfterTry) {
        if (callForTry == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(37);
        }
        if (dataFlowInfoBeforeTry == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(38);
        }
        if (dataFlowInfoAfterTry == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(39);
        }
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = new HashMap<ValueArgument, DataFlowInfo>();
        List<? extends ValueArgument> valueArguments = callForTry.getValueArguments();
        dataFlowInfoForArgumentsMap.put(valueArguments.get(0), dataFlowInfoBeforeTry);
        for (int i2 = 1; i2 < valueArguments.size(); ++i2) {
            dataFlowInfoForArgumentsMap.put(valueArguments.get(i2), dataFlowInfoAfterTry);
        }
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(dataFlowInfoBeforeTry, dataFlowInfoForArgumentsMap);
    }

    public static Call createCallForSpecialConstruction(final @NotNull KtExpression expression2, final @NotNull KtExpression calleeExpression, @NotNull List<? extends KtExpression> arguments2) {
        if (expression2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(40);
        }
        if (calleeExpression == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(41);
        }
        if (arguments2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(42);
        }
        final ArrayList<ValueArgument> valueArguments = Lists.newArrayList();
        for (KtExpression ktExpression : arguments2) {
            valueArguments.add(CallMaker.makeValueArgument(ktExpression));
        }
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return expression2.getNode();
            }

            @Override
            @Nullable
            public ReceiverValue getExplicitReceiver() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return calleeExpression;
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list = valueArguments;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                List<LambdaArgument> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtExpression ktExpression = expression2;
                if (ktExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                return ktExpression;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return callType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private TracingStrategy createTracingForSpecialConstruction(final @NotNull Call call2, @NotNull String constructionName, final @NotNull ExpressionTypingContext context2) {
        if (call2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(43);
        }
        if (constructionName == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(44);
        }
        if (context2 == null) {
            ControlStructureTypingUtils.$$$reportNull$$$0(45);
        }
        class CheckTypeContext {
            public BindingTrace trace;
            public KotlinType expectedType;

            CheckTypeContext(@NotNull BindingTrace trace, KotlinType expectedType) {
                if (trace == null) {
                    CheckTypeContext.$$$reportNull$$$0(0);
                }
                if (expectedType == null) {
                    CheckTypeContext.$$$reportNull$$$0(1);
                }
                this.trace = trace;
                this.expectedType = expectedType;
            }

            CheckTypeContext makeTypeNullable() {
                if (TypeUtils.noExpectedType(this.expectedType)) {
                    return this;
                }
                return new CheckTypeContext(this.trace, TypeUtils.makeNullable(this.expectedType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "trace";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedType";
                        break;
                    }
                }
                objectArray[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$1CheckTypeContext";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        final KtVisitor<Boolean, CheckTypeContext> checkTypeVisitor = new KtVisitor<Boolean, CheckTypeContext>(){

            private boolean checkExpressionType(@NotNull KtExpression expression2, CheckTypeContext c2) {
                KotlinTypeInfo typeInfo;
                if (expression2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((typeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, c2.trace.getBindingContext())) == null) {
                    return false;
                }
                Ref<Boolean> hasError = Ref.create();
                ControlStructureTypingUtils.this.dataFlowAnalyzer.checkType(typeInfo.getType(), expression2, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(c2.expectedType)).replaceDataFlowInfo(typeInfo.getDataFlowInfo())).replaceBindingTrace(c2.trace), hasError, true);
                return hasError.get();
            }

            private boolean checkExpressionTypeRecursively(@Nullable KtExpression expression2, CheckTypeContext c2) {
                if (expression2 == null) {
                    return false;
                }
                return expression2.accept(this, c2);
            }

            private boolean checkSubExpressions(KtExpression firstSub, KtExpression secondSub, KtExpression expression2, CheckTypeContext firstContext, CheckTypeContext secondContext, CheckTypeContext context22) {
                boolean errorWasReported = this.checkExpressionTypeRecursively(firstSub, firstContext);
                return (errorWasReported |= this.checkExpressionTypeRecursively(secondSub, secondContext)) || this.checkExpressionType(expression2, context22);
            }

            @Override
            public Boolean visitWhenExpression(@NotNull KtWhenExpression whenExpression, CheckTypeContext c2) {
                if (whenExpression == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean errorWasReported = false;
                for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
                    KtExpression entryExpression = whenEntry.getExpression();
                    if (entryExpression == null) continue;
                    errorWasReported |= this.checkExpressionTypeRecursively(entryExpression, c2);
                }
                return errorWasReported |= this.checkExpressionType(whenExpression, c2);
            }

            @Override
            public Boolean visitIfExpression(@NotNull KtIfExpression ifExpression, CheckTypeContext c2) {
                if (ifExpression == null) {
                    2.$$$reportNull$$$0(2);
                }
                KtExpression thenBranch = ifExpression.getThen();
                KtExpression elseBranch = ifExpression.getElse();
                if (thenBranch == null || elseBranch == null) {
                    return this.checkExpressionType(ifExpression, c2);
                }
                return this.checkSubExpressions(thenBranch, elseBranch, ifExpression, c2, c2, c2);
            }

            @Override
            public Boolean visitBlockExpression(@NotNull KtBlockExpression expression2, CheckTypeContext c2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (expression2.getStatements().isEmpty()) {
                    return this.checkExpressionType(expression2, c2);
                }
                KtExpression lastStatement = KtPsiUtil.getLastStatementInABlock(expression2);
                if (lastStatement != null) {
                    return this.checkExpressionTypeRecursively(lastStatement, c2);
                }
                return false;
            }

            @Override
            public Boolean visitPostfixExpression(@NotNull KtPostfixExpression expression2, CheckTypeContext c2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
                    return this.checkExpressionTypeRecursively(expression2.getBaseExpression(), c2.makeTypeNullable());
                }
                return (Boolean)super.visitPostfixExpression(expression2, c2);
            }

            @Override
            public Boolean visitBinaryExpression(@NotNull KtBinaryExpression expression2, CheckTypeContext c2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.ELVIS) {
                    return this.checkSubExpressions(expression2.getLeft(), expression2.getRight(), expression2, c2.makeTypeNullable(), c2, c2);
                }
                return (Boolean)super.visitBinaryExpression(expression2, c2);
            }

            @Override
            public Boolean visitExpression(@NotNull KtExpression expression2, CheckTypeContext c2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                return this.checkExpressionType(expression2, c2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "whenExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifExpression";
                        break;
                    }
                }
                objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkExpressionType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhenExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBlockExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPostfixExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new ThrowingOnErrorTracingStrategy("resolve " + constructionName + " as a call"){

            @Override
            public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
                if (trace == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (resolvedCall2 == null) {
                    3.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void bindCall(@NotNull BindingTrace trace, @NotNull Call call22) {
                if (trace == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (call22 == null) {
                    3.$$$reportNull$$$0(3);
                }
                trace.record(BindingContext.CALL, call22.getCalleeExpression(), call22);
            }

            @Override
            public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
                if (trace == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (resolvedCall2 == null) {
                    3.$$$reportNull$$$0(5);
                }
                trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
            }

            @Override
            public void typeInferenceFailed(@NotNull ResolutionContext<?> context2, @NotNull InferenceErrorData data) {
                if (context2 == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (data == null) {
                    3.$$$reportNull$$$0(7);
                }
                ConstraintSystem constraintSystem = data.constraintSystem;
                ConstraintSystemStatus status2 = constraintSystem.getStatus();
                assert (!status2.isSuccessful()) : "Report error only for not successful constraint system";
                if (status2.hasErrorInConstrainingTypes() || status2.hasUnknownParameters()) {
                    return;
                }
                KtExpression expression2 = (KtExpression)call2.getCallElement();
                if (status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION) || status2.hasConflictingConstraints() || status2.hasTypeInferenceIncorporationError()) {
                    KtExpression calleeExpression;
                    if (this.noTypeCheckingErrorsInExpression(expression2, context2.trace, data.expectedType) && ((calleeExpression = call2.getCalleeExpression()) instanceof KtWhenExpression || calleeExpression instanceof KtIfExpression) && (status2.hasConflictingConstraints() || status2.hasTypeInferenceIncorporationError())) {
                        context2.trace.report(Errors.TYPE_INFERENCE_FAILED_ON_SPECIAL_CONSTRUCT.on(expression2));
                    }
                    return;
                }
                KtDeclaration parentDeclaration2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtNamedDeclaration.class);
                this.logError("Expression: " + (parentDeclaration2 != null ? parentDeclaration2.getText() : expression2.getText()) + "\nConstraint system status: \n" + ConstraintsUtil.getDebugMessageForStatus(status2));
            }

            private boolean noTypeCheckingErrorsInExpression(KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
                if (trace == null) {
                    3.$$$reportNull$$$0(8);
                }
                if (expectedType == null) {
                    3.$$$reportNull$$$0(9);
                }
                return Boolean.TRUE != expression2.accept(checkTypeVisitor, new CheckTypeContext(trace, expectedType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trace";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolvedCall";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedType";
                        break;
                    }
                }
                objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bindReference";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bindCall";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bindResolvedCall";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "typeInferenceFailed";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "noTypeCheckingErrorsInExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowAnalyzer";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "construct";
                break;
            }
            case 6: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentNames";
                break;
            }
            case 7: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isArgumentNullable";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchedExceptions";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataFlowInfo";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfoForArgumentsMap";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callForIf";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionInfo";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenInfo";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseInfo";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callForWhen";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectDataFlowInfo";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryDataFlowInfos";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callForTry";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfoBeforeTry";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfoAfterTry";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructionName";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSpecialConstructionAsCall";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveTryAsCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createKnownTypeParameterSubstitutorForSpecialCall";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "createFunctionDescriptorForSpecialConstruction";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "createIndependentDataFlowInfoForArgumentsForCall";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "createDataFlowInfoForArgumentsForIfCall";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "createDataFlowInfoForArgumentsOfWhenCall";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "createDataFlowInfoForArgumentsOfTryCall";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "createCallForSpecialConstruction";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "createTracingForSpecialConstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class ThrowingOnErrorTracingStrategy
    implements TracingStrategy {
        private final String debugName;

        protected ThrowingOnErrorTracingStrategy(String debugName) {
            this.debugName = debugName;
        }

        private void logError() {
            this.logError(null);
        }

        protected void logError(@Nullable String additionalInformation) {
            String errorMessage = "Resolution error of this type shouldn't occur for " + this.debugName;
            if (additionalInformation != null) {
                errorMessage = errorMessage + ".\n" + additionalInformation;
            }
            LOG.error(errorMessage);
        }

        @Override
        public void unresolvedReference(@NotNull BindingTrace trace) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(0);
            }
            this.logError();
        }

        @Override
        public void recursiveType(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, boolean insideAugmentedAssignment) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(1);
            }
            if (languageVersionSettings == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(2);
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(3);
            }
            if (candidates2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(4);
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(5);
            }
            if (candidates2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(6);
            }
            this.logError();
        }

        @Override
        public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(7);
            }
            if (expectedReceiver == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(8);
            }
            this.logError();
        }

        @Override
        public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(9);
            }
            if (receiverParameter == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(10);
            }
            if (receiverArgument == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(11);
            }
            if (c2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(12);
            }
            this.logError();
        }

        @Override
        public void noReceiverAllowed(@NotNull BindingTrace trace) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(13);
            }
            this.logError();
        }

        @Override
        public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(14);
            }
            if (valueParameter2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(15);
            }
            this.logError();
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(16);
            }
            if (descriptor2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(17);
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> resolvedCalls) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(18);
            }
            if (resolvedCalls == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(19);
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(20);
            }
            if (descriptors == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(21);
            }
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(22);
            }
            if (descriptors == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(23);
            }
            this.logError();
        }

        @Override
        public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(24);
            }
            this.logError();
        }

        @Override
        public void abstractSuperCall(@NotNull BindingTrace trace) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(25);
            }
            this.logError();
        }

        @Override
        public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ExplicitReceiverKind explicitReceiverKind) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(26);
            }
            if (classDescriptor == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(27);
            }
            if (explicitReceiverKind == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(28);
            }
            this.logError();
        }

        @Override
        public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(29);
            }
            if (type2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(30);
            }
            this.logError();
        }

        @Override
        public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
            if (trace == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(31);
            }
            if (descriptor2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(32);
            }
            this.logError();
        }

        @Override
        public void typeInferenceFailed(@NotNull ResolutionContext<?> context2, @NotNull InferenceErrorData inferenceErrorData) {
            if (context2 == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(33);
            }
            if (inferenceErrorData == null) {
                ThrowingOnErrorTracingStrategy.$$$reportNull$$$0(34);
            }
            this.logError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageVersionSettings";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedReceiver";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverParameter";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverArgument";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParameter";
                    break;
                }
                case 17: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedCalls";
                    break;
                }
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDescriptor";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitReceiverKind";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inferenceErrorData";
                    break;
                }
            }
            objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unresolvedReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "recursiveType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unresolvedReferenceWrongReceiver";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "recordAmbiguity";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "missingReceiver";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrongReceiverType";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "noReceiverAllowed";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "noValueForParameter";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrongNumberOfTypeArguments";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ambiguity";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "noneApplicable";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cannotCompleteResolve";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "instantiationOfAbstractClass";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "abstractSuperCall";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nestedClassAccessViaInstanceReference";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsafeCall";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invisibleMember";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[2] = "typeInferenceFailed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ControlStructureDataFlowInfo
    extends MutableDataFlowInfoForArguments {
        public final Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap;

        ControlStructureDataFlowInfo(@NotNull DataFlowInfo initialDataFlowInfo, @NotNull Map<ValueArgument, DataFlowInfo> map) {
            if (initialDataFlowInfo == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(0);
            }
            if (map == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(1);
            }
            super(initialDataFlowInfo);
            this.dataFlowInfoForArgumentsMap = map;
        }

        @Override
        public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
            if (valueArgument == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(2);
            }
            if (dataFlowInfo == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(3);
            }
            this.dataFlowInfoForArgumentsMap.put(valueArgument, dataFlowInfo);
        }

        @Override
        public void updateResultInfo(@NotNull DataFlowInfo dataFlowInfo) {
            if (dataFlowInfo == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(4);
            }
        }

        @Override
        @NotNull
        public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
            if (valueArgument == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(5);
            }
            DataFlowInfo dataFlowInfo = this.dataFlowInfoForArgumentsMap.get(valueArgument);
            if (dataFlowInfo == null) {
                ControlStructureDataFlowInfo.$$$reportNull$$$0(6);
            }
            return dataFlowInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialDataFlowInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueArgument";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlowInfo";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ControlStructureDataFlowInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/types/expressions/ControlStructureTypingUtils$ControlStructureDataFlowInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateResultInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfo";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ResolveConstruct {
        IF("if"),
        ELVIS("elvis"),
        EXCL_EXCL("ExclExcl"),
        WHEN("when"),
        TRY("try");

        private final String name;
        private final Name specialFunctionName;
        private final Name specialTypeParameterName;

        private ResolveConstruct(String name2) {
            this.name = name2;
            this.specialFunctionName = Name.identifier("<SPECIAL-FUNCTION-FOR-" + name2.toUpperCase() + "-RESOLVE>");
            this.specialTypeParameterName = Name.identifier("<TYPE-PARAMETER-FOR-" + name2.toUpperCase() + "-RESOLVE>");
        }

        public String getName() {
            return this.name;
        }

        public Name getSpecialFunctionName() {
            return this.specialFunctionName;
        }

        public Name getSpecialTypeParameterName() {
            return this.specialTypeParameterName;
        }
    }
}

