/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/ResolutionToPrivateConstructorOfSealedClassChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ResolutionToPrivateConstructorOfSealedClassChecker
implements CallChecker {
    @NotNull
    public static final ResolutionToPrivateConstructorOfSealedClassChecker INSTANCE = new ResolutionToPrivateConstructorOfSealedClassChecker();

    private ResolutionToPrivateConstructorOfSealedClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ReceiverValue receiver;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage)) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.UseConsistentRulesForPrivateConstructorsOfSealedClasses)) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        ConstructorDescriptor constructorDescriptor = obj instanceof ConstructorDescriptor ? (ConstructorDescriptor)obj : null;
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorDescriptor descriptor2 = constructorDescriptor;
        if (!Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return;
        }
        ClassDescriptor classDescriptor = descriptor2.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
        if (!DescriptorUtilKt.isSealed(classDescriptor)) {
            return;
        }
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (receiverValue == null) {
            receiverValue = DescriptorVisibilities.ALWAYS_SUITABLE_RECEIVER;
        }
        if (DescriptorVisibilities.findInvisibleMember(receiver = receiverValue, descriptor2, containingDescriptor, false) != null) {
            context2.getTrace().report(Errors.RESOLUTION_TO_PRIVATE_CONSTRUCTOR_OF_SEALED_CLASS.on(reportOn));
        }
    }
}

