/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.util.CheckResult;
import ksp.org.jetbrains.kotlin.util.OperatorChecks;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/resolve/OperatorModifierChecker;", "", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "checkSupportsFeature", "feature", "Lksp/org/jetbrains/kotlin/config/LanguageFeature;", "modifier", "Lksp/com/intellij/psi/PsiElement;", "frontend"})
public final class OperatorModifierChecker {
    @NotNull
    public static final OperatorModifierChecker INSTANCE = new OperatorModifierChecker();

    private OperatorModifierChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        FunctionDescriptor functionDescriptor = descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!functionDescriptor2.isOperator()) {
            return;
        }
        PsiElement psiElement = declaration2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OPERATOR_KEYWORD)) == null) {
            return;
        }
        PsiElement modifier = psiElement;
        CheckResult checkResult = OperatorChecks.INSTANCE.check(functionDescriptor2);
        if (checkResult.isSuccess()) {
            if (Intrinsics.areEqual((Object)functionDescriptor2.getName(), (Object)OperatorNameConventions.PROVIDE_DELEGATE)) {
                this.checkSupportsFeature(LanguageFeature.OperatorProvideDelegate, languageVersionSettings, diagnosticHolder, modifier);
            } else if (DescriptorUtilKt.isTypedEqualsInValueClass(functionDescriptor2)) {
                this.checkSupportsFeature(LanguageFeature.CustomEqualsInValueClasses, languageVersionSettings, diagnosticHolder, modifier);
            }
            return;
        }
        Object object = checkResult instanceof CheckResult.IllegalSignature ? (CheckResult.IllegalSignature)checkResult : null;
        if (object == null || (object = ((CheckResult.IllegalSignature)object).getError()) == null) {
            object = "illegal function name";
        }
        Object errorDescription = object;
        diagnosticHolder.report(Errors.INAPPLICABLE_OPERATOR_MODIFIER.on(modifier, (String)errorDescription));
    }

    private final void checkSupportsFeature(LanguageFeature feature, LanguageVersionSettings languageVersionSettings, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        if (!languageVersionSettings.supportsFeature(feature)) {
            diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(modifier, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)feature), (Object)languageVersionSettings)));
        }
    }
}

