/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion;
import ksp.org.jetbrains.kotlin.js.naming.SuggestedName;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "suggestion", "Lksp/org/jetbrains/kotlin/js/naming/NameSuggestion;", "<init>", "(Lorg/jetbrains/kotlin/js/naming/NameSuggestion;)V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsNameCharsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1761#2,3:47\n*S KotlinDebug\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n*L\n41#1:47,3\n*E\n"})
public abstract class AbstractNameCharsChecker
implements DeclarationChecker {
    @NotNull
    private final NameSuggestion suggestion;

    public AbstractNameCharsChecker(@NotNull NameSuggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        this.suggestion = suggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (descriptor2 instanceof PropertyAccessorDescriptor && AnnotationsUtils.getJsName(descriptor2) == null) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && AnnotationsUtils.getJsName(descriptor2) == null && AnnotationsUtils.isExportedObject(descriptor2, bindingContext2)) {
            return;
        }
        SuggestedName suggestedName = this.suggestion.suggest(descriptor2, bindingContext2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        if (suggestedName2.getStable()) {
            boolean bl2;
            block9: {
                Iterable $this$any$iv = suggestedName2.getNames();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it))) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                context2.getTrace().report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on(declaration2));
            }
        }
    }
}

