/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.AnalysisFlag;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.ExplicitApiMode;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkVisibilityModifier", "state", "Lksp/org/jetbrains/kotlin/config/ExplicitApiMode;", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "explicitVisibilityIsNotRequired", "", "checkExplicitReturnType", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "returnTypeCheckIsApplicable", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitApiDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n30#2:163\n39#2:167\n45#3:164\n19#3:165\n66#3:166\n1#4:168\n*S KotlinDebug\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n*L\n60#1:163\n126#1:167\n63#1:164\n64#1:165\n120#1:166\n*E\n"})
public final class FirExplicitApiDeclarationChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final FirExplicitApiDeclarationChecker INSTANCE = new FirExplicitApiDeclarationChecker();

    private FirExplicitApiDeclarationChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        EffectiveVisibility containerEffectiveVisibility;
        EffectiveVisibility effectiveVisibility;
        boolean $i$f$getEffectiveVisibility;
        FirBasedSymbol $this$effectiveVisibility$iv;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean sourceKindIsReal = source.getKind() instanceof KtRealSourceElementKind;
        if (!sourceKindIsReal && !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) || Intrinsics.areEqual((Object)element2.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE) || !(element2 instanceof FirMemberDeclaration)) {
            return;
        }
        ExplicitApiMode explicitApiState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context2, AnalysisFlags.getExplicitApiMode());
        ExplicitApiMode explicitReturnTypesState = FirExplicitApiDeclarationChecker.checkPsiOrLightTree$extractState(context2, AnalysisFlags.getExplicitReturnTypes());
        if (explicitApiState == null && explicitReturnTypesState == null) {
            return;
        }
        if (element2 instanceof FirEnumEntry) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv2 = (FirMemberDeclaration)element2;
        boolean $i$f$getEffectiveVisibility2 = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv2.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (!((EffectiveVisibility)object).getPublicApi() && PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility(element2) == null) {
            return;
        }
        FirBasedSymbol lastContainingDeclaration = (FirBasedSymbol)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (lastContainingDeclaration instanceof FirClassSymbol) {
            $this$effectiveVisibility$iv = (FirClassLikeSymbol)lastContainingDeclaration;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else if (lastContainingDeclaration instanceof FirCallableSymbol) {
            $this$effectiveVisibility$iv = (FirCallableSymbol)lastContainingDeclaration;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility = null;
        }
        EffectiveVisibility effectiveVisibility2 = containerEffectiveVisibility = effectiveVisibility;
        boolean bl2 = effectiveVisibility2 != null ? !effectiveVisibility2.getPublicApi() : false;
        if (bl2) {
            return;
        }
        if (explicitApiState != null) {
            this.checkVisibilityModifier(explicitApiState, (FirMemberDeclaration)element2, source, context2, reporter);
        }
        if (sourceKindIsReal && element2 instanceof FirCallableDeclaration) {
            ExplicitApiMode explicitApiMode = explicitApiState;
            if (explicitApiMode == null) {
                ExplicitApiMode explicitApiMode2 = explicitReturnTypesState;
                explicitApiMode = explicitApiMode2;
                Intrinsics.checkNotNull((Object)((Object)explicitApiMode2));
            }
            this.checkExplicitReturnType(explicitApiMode, (FirCallableDeclaration)element2, source, context2, reporter);
        }
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, FirMemberDeclaration declaration2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement visibilityModifier;
        KtSourceElement ktSourceElement;
        IElementType iElementType = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MODIFIER_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VISIBILITY_MODIFIERS");
            ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement2, tokenSet, 0, 0, false, 14, null);
        } else {
            ktSourceElement = visibilityModifier = null;
        }
        if (visibilityModifier != null) {
            return;
        }
        if (this.explicitVisibilityIsNotRequired(declaration2, context2)) {
            return;
        }
        KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean explicitVisibilityIsNotRequired(FirMemberDeclaration declaration2, CheckerContext context2) {
        boolean bl2;
        FirMemberDeclaration firMemberDeclaration = declaration2;
        if (firMemberDeclaration instanceof FirPrimaryConstructor || firMemberDeclaration instanceof FirPropertyAccessor || firMemberDeclaration instanceof FirValueParameter || firMemberDeclaration instanceof FirAnonymousFunction) {
            bl2 = true;
        } else if (firMemberDeclaration instanceof FirCallableDeclaration) {
            FirRegularClassSymbol containingClass;
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClassSymbol firRegularClassSymbol = containingClass = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
            if (declaration2 instanceof FirProperty && containingClass != null) {
                FirClassLikeSymbol $this$isData$iv = containingClass;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getRawStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            FirMemberDeclaration $this$isOverride$iv = declaration2;
            boolean $i$f$isOverride = false;
            bl2 = $this$isOverride$iv.getStatus().isOverride() || DeclarationUtilsKt.isLocalMember(declaration2);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, FirCallableDeclaration declaration2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (!this.returnTypeCheckIsApplicable(declaration2)) {
            return;
        }
        KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean returnTypeCheckIsApplicable(FirCallableDeclaration $this$returnTypeCheckIsApplicable) {
        KtSourceElement ktSourceElement = $this$returnTypeCheckIsApplicable.getReturnTypeRef().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return false;
        }
        return $this$returnTypeCheckIsApplicable instanceof FirProperty || $this$returnTypeCheckIsApplicable instanceof FirFunction && !($this$returnTypeCheckIsApplicable instanceof FirPropertyAccessor) && ((FirFunction)$this$returnTypeCheckIsApplicable).getBody() instanceof FirSingleExpressionBlock;
    }

    private static final ExplicitApiMode checkPsiOrLightTree$extractState(CheckerContext $context, AnalysisFlag<? extends ExplicitApiMode> flag) {
        ExplicitApiMode explicitApiMode;
        ExplicitApiMode it = explicitApiMode = $context.getLanguageVersionSettings().getFlag(flag);
        boolean bl2 = false;
        return !(it == ExplicitApiMode.DISABLED) ? explicitApiMode : null;
    }
}

