/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDataClassCopyUsageWillBecomeInaccessibleCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirDataClassCopyUsageWillBecomeInaccessibleChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
public final class FirDataClassCopyUsageWillBecomeInaccessibleChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirDataClassCopyUsageWillBecomeInaccessibleChecker INSTANCE = new FirDataClassCopyUsageWillBecomeInaccessibleChecker();

    private FirDataClassCopyUsageWillBecomeInaccessibleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!(expression2 instanceof FirFunctionCall) && !(expression2 instanceof FirCallableReferenceAccess)) {
            return;
        }
        FirBasedSymbol<?> firBasedSymbol = FirReferenceUtilsKt.getSymbol(expression2.getCalleeReference());
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol copyFunction = firCallableSymbol;
        Object object = ClassMembersKt.containingClassLookupTag(copyFunction);
        if (object == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) {
            return;
        }
        Object dataClass = object;
        if (FirDataClassCopyUsageWillBecomeInaccessibleCheckerKt.isDataClassCopy(copyFunction, (FirClassSymbol)dataClass, context2.getSession())) {
            boolean hasCopyAlreadyBecameInaccessible;
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny((FirClassSymbol)dataClass, context2.getSession());
            if (firConstructorSymbol == null) {
                return;
            }
            FirConstructorSymbol dataClassConstructor = firConstructorSymbol;
            FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
            if (firFileSymbol == null) {
                return;
            }
            boolean bl2 = hasCopyAlreadyBecameInaccessible = !FirVisibilityCheckerKt.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), copyFunction, context2.getSession(), firFileSymbol, context2.getContainingDeclarations(), null, false, 32, null);
            if (hasCopyAlreadyBecameInaccessible) {
                return;
            }
            FirFileSymbol firFileSymbol2 = context2.getContainingFileSymbol();
            if (firFileSymbol2 == null) {
                return;
            }
            boolean isConstructorVisible = FirVisibilityCheckerKt.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), dataClassConstructor, context2.getSession(), firFileSymbol2, context2.getContainingDeclarations(), null, false, 32, null);
            if (!isConstructorVisible) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getDATA_CLASS_INVISIBLE_COPY_USAGE(), null, 8, null);
            }
        }
    }
}

