/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)V", "checkForLocalConflictingFunctions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n2746#2,3:41\n827#2:44\n855#2,2:45\n*S KotlinDebug\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n*L\n22#1:41,3\n23#1:44\n23#1:45,2\n*E\n"})
public final class FirConflictsExpressionChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirConflictsExpressionChecker INSTANCE = new FirConflictsExpressionChecker();

    private FirConflictsExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirBlock expression2) {
        List list;
        boolean bl2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Iterable $this$none$iv = expression2.getStatements();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl3 = false;
                    if (!FirDeclarationUtilKt.isDestructuredParameter(it)) continue;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            list = expression2.getStatements();
        } else {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = expression2.getStatements();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirStatement it = (FirStatement)element$iv$iv;
                boolean bl4 = false;
                if (FirDeclarationUtilKt.isDestructuredParameter(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List elements = list;
        FirConflictsHelpersKt.checkForLocalRedeclarations(elements, context2, reporter);
        this.checkForLocalConflictingFunctions(expression2, context2, reporter);
    }

    private final void checkForLocalConflictingFunctions(FirBlock expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Map<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> conflictingFunctions = FirConflictsHelpersKt.collectConflictingLocalFunctionsFrom(expression2, context2);
        for (Map.Entry<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> entry : conflictingFunctions.entrySet()) {
            FirFunctionSymbol<?> function2 = entry.getKey();
            Set<FirBasedSymbol<?>> otherFunctionsThatConflictWithIt = entry.getValue();
            if (otherFunctionsThatConflictWithIt.isEmpty()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), otherFunctionsThatConflictWithIt, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

