/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Set declaredLater = new LinkedHashSet();
        FirVisitorVoid visitor2 = new FirVisitorVoid(declaredLater, context2, reporter){
            final /* synthetic */ Set<FirPropertySymbol> $declaredLater;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$declaredLater = $declaredLater;
                this.$context = $context;
                this.$reporter = $reporter;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitConstructor(FirConstructor constructor) {
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            }

            public void visitSimpleFunction(FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            }

            public void visitPropertyAccessor(FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            }

            public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            }

            public void visitRegularClass(FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            }

            public void visitEnumEntry(FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            }

            public void visitVariableAssignment(FirVariableAssignment variableAssignment) {
                Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                variableAssignment.acceptChildren(this);
                FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol propertySymbol = firPropertySymbol;
                if (!this.$declaredLater.contains(propertySymbol)) {
                    return;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, null, 16, null);
            }
        };
        for (FirDeclaration member : CollectionsKt.asReversed(declaration2.getDeclarations())) {
            if (!((Collection)declaredLater).isEmpty()) {
                member.accept(visitor2);
            }
            if (!(member instanceof FirProperty)) continue;
            declaredLater.add(((FirProperty)member).getSymbol());
        }
    }
}

