/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.mapping;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import ksp.org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper;", "", "<init>", "()V", "mapSignature", "Lksp/org/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodGenericSignature;", "irFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "genericSignature", "methodNameToProcessors", "", "", "", "Lksp/org/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureProcessor;", "SignatureKind", "SignatureProcessor", "backend.jvm"})
public final class GenericSignatureMapper {
    @NotNull
    public static final GenericSignatureMapper INSTANCE = new GenericSignatureMapper();
    @NotNull
    private static final Map<String, List<SignatureProcessor>> methodNameToProcessors;

    private GenericSignatureMapper() {
    }

    @NotNull
    public final JvmMethodGenericSignature mapSignature(@NotNull IrSimpleFunction irFunction, @NotNull JvmMethodGenericSignature genericSignature) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)genericSignature, (String)"genericSignature");
        String string = genericSignature.getGenericsSignature();
        if (string == null) {
            return genericSignature;
        }
        String signature = string;
        Method method = genericSignature.getAsmMethod();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getAsmMethod(...)");
        Method method2 = method;
        List<SignatureProcessor> list = methodNameToProcessors.get(method2.getName());
        if (list == null) {
            return genericSignature;
        }
        List<SignatureProcessor> processors = list;
        for (SignatureProcessor processor : processors) {
            if (!processor.match(irFunction, method2)) continue;
            return new JvmMethodGenericSignature(method2, genericSignature.getParameters(), processor.process(signature));
        }
        return genericSignature;
    }

    private static final boolean methodNameToProcessors$lambda$0(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method.getArgumentTypes().length == 2;
    }

    static {
        Pair[] pairArray = new Pair[11];
        pairArray[0] = TuplesKt.to((Object)"contains", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.collection, "(Ljava/lang/Object;)Z", SignatureKind.NON_GENERIC, null, 8, null)));
        pairArray[1] = TuplesKt.to((Object)"containsAll", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.collection, "(Ljava/util/Collection;)Z", SignatureKind.FIXED_COLLECTION_PARAMETER, null, 8, null)));
        pairArray[2] = TuplesKt.to((Object)"containsKey", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.map, "(Ljava/lang/Object;)Z", SignatureKind.NON_GENERIC, null, 8, null)));
        pairArray[3] = TuplesKt.to((Object)"containsValue", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.map, "(Ljava/lang/Object;)Z", SignatureKind.NON_GENERIC, null, 8, null)));
        pairArray[4] = TuplesKt.to((Object)"get", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.map, "(Ljava/lang/Object;)", SignatureKind.FIRST_PARAMETER_ERASED, null, 8, null)));
        pairArray[5] = TuplesKt.to((Object)"getOrDefault", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.map, "(Ljava/lang/Object;", SignatureKind.FIRST_PARAMETER_ERASED, (Function1<? super Method, Boolean>)((Function1)GenericSignatureMapper::methodNameToProcessors$lambda$0))));
        pairArray[6] = TuplesKt.to((Object)"indexOf", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.list, "(Ljava/lang/Object;)I", SignatureKind.NON_GENERIC, null, 8, null)));
        pairArray[7] = TuplesKt.to((Object)"lastIndexOf", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.list, "(Ljava/lang/Object;)I", SignatureKind.NON_GENERIC, null, 8, null)));
        Object[] objectArray = new SignatureProcessor[]{new SignatureProcessor(StandardNames.FqNames.mutableCollection, "(Ljava/lang/Object;)Z", SignatureKind.NON_GENERIC, null, 8, null), new SignatureProcessor(StandardNames.FqNames.mutableMap, "(Ljava/lang/Object;)", SignatureKind.FIRST_PARAMETER_ERASED, null, 8, null), new SignatureProcessor(StandardNames.FqNames.mutableMap, "(Ljava/lang/Object;Ljava/lang/Object;)Z", SignatureKind.NON_GENERIC, null, 8, null)};
        pairArray[8] = TuplesKt.to((Object)"remove", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[9] = TuplesKt.to((Object)"removeAll", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.mutableCollection, "(Ljava/util/Collection;)Z", SignatureKind.FIXED_COLLECTION_PARAMETER, null, 8, null)));
        pairArray[10] = TuplesKt.to((Object)"retainAll", (Object)CollectionsKt.listOf((Object)new SignatureProcessor(StandardNames.FqNames.mutableCollection, "(Ljava/util/Collection;)Z", SignatureKind.FIXED_COLLECTION_PARAMETER, null, 8, null)));
        methodNameToProcessors = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureKind;", "", "<init>", "(Ljava/lang/String;I)V", "NON_GENERIC", "FIXED_COLLECTION_PARAMETER", "FIRST_PARAMETER_ERASED", "backend.jvm"})
    private static final class SignatureKind
    extends Enum<SignatureKind> {
        public static final /* enum */ SignatureKind NON_GENERIC = new SignatureKind();
        public static final /* enum */ SignatureKind FIXED_COLLECTION_PARAMETER = new SignatureKind();
        public static final /* enum */ SignatureKind FIRST_PARAMETER_ERASED = new SignatureKind();
        private static final /* synthetic */ SignatureKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SignatureKind[] values() {
            return (SignatureKind[])$VALUES.clone();
        }

        public static SignatureKind valueOf(String value2) {
            return Enum.valueOf(SignatureKind.class, value2);
        }

        @NotNull
        public static EnumEntries<SignatureKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = signatureKindArray = new SignatureKind[]{SignatureKind.NON_GENERIC, SignatureKind.FIXED_COLLECTION_PARAMETER, SignatureKind.FIRST_PARAMETER_ERASED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureProcessor;", "", "builtinFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "descriptorPrefix", "", "kind", "Lksp/org/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureKind;", "checker", "Lkotlin/Function1;", "Lksp/org/jetbrains/org/objectweb/asm/commons/Method;", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Lorg/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureKind;Lkotlin/jvm/functions/Function1;)V", "match", "irFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "method", "process", "signature", "backend.jvm"})
    @SourceDebugExtension(value={"SMAP\nGenericSignatureMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1761#2,3:203\n*S KotlinDebug\n*F\n+ 1 GenericSignatureMapper.kt\norg/jetbrains/kotlin/backend/jvm/mapping/GenericSignatureMapper$SignatureProcessor\n*L\n31#1:203,3\n*E\n"})
    private static final class SignatureProcessor {
        @NotNull
        private final FqName builtinFqName;
        @NotNull
        private final String descriptorPrefix;
        @NotNull
        private final SignatureKind kind;
        @Nullable
        private final Function1<Method, Boolean> checker;

        public SignatureProcessor(@NotNull FqName builtinFqName, @NotNull String descriptorPrefix, @NotNull SignatureKind kind, @Nullable Function1<? super Method, Boolean> checker) {
            Intrinsics.checkNotNullParameter((Object)builtinFqName, (String)"builtinFqName");
            Intrinsics.checkNotNullParameter((Object)descriptorPrefix, (String)"descriptorPrefix");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            this.builtinFqName = builtinFqName;
            this.descriptorPrefix = descriptorPrefix;
            this.kind = kind;
            this.checker = checker;
        }

        public /* synthetic */ SignatureProcessor(FqName fqName, String string, SignatureKind signatureKind, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            this(fqName, string, signatureKind, (Function1<? super Method, Boolean>)function1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean match(@NotNull IrSimpleFunction irFunction, @NotNull Method method) {
            IrClass irClass;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String string = method.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptor(...)");
            if (!StringsKt.startsWith$default((String)string, (String)this.descriptorPrefix, (boolean)false, (int)2, null)) return false;
            Function1<Method, Boolean> function1 = this.checker;
            if (function1 != null) {
                if (!((Boolean)function1.invoke((Object)method)).booleanValue()) {
                    return false;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return false;
            Iterable $this$any$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)irFunction, false);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl3 = false;
                irClass = IrUtilsKt.getParentClassOrNull(it);
            } while (!Intrinsics.areEqual((Object)(irClass != null ? IrUtilsKt.getFqNameWhenAvailable(irClass) : null), (Object)this.builtinFqName));
            return true;
        }

        @Nullable
        public final String process(@NotNull String signature) {
            String string;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
                case 1: {
                    string = null;
                    break;
                }
                case 2: {
                    string = "(Ljava/util/Collection<*>;)Z";
                    break;
                }
                case 3: {
                    string = "(Ljava/lang/Object;" + StringsKt.substringAfter$default((String)signature, (char)';', null, (int)2, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignatureKind.values().length];
                try {
                    nArray[SignatureKind.NON_GENERIC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureKind.FIXED_COLLECTION_PARAMETER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureKind.FIRST_PARAMETER_ERASED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

