/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.text;

import java.nio.charset.StandardCharsets;
import ksp.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.org.jetbrains.annotations.NotNull;

public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start, int end) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(1);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            this.hash = h2 = Strings.stringHashCode(this, 0, this.length());
        }
        return h2;
    }

    @Override
    public int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public char charAt(int index2) {
        return (char)(this.myChars[index2 + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new ByteArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    public void getChars(int start, int end, char[] dest, int pos) {
        for (int idx = start; idx < end; ++idx) {
            dest[idx - start + pos] = (char)(this.myChars[idx + this.myStart] & 0xFF);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "ksp/com/intellij/util/text/ByteArrayCharSequence", "<init>"));
    }
}

