/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.testFramework;

import java.io.IOException;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import ksp.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.openapi.vfs.VirtualFileWithAssignedFileType;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class LightVirtualFileBase
extends VirtualFile
implements VirtualFileWithAssignedFileType {
    private FileType myFileType;
    @NlsSafe
    private String myName;
    private long myModStamp;
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(@NlsSafe String name2, FileType fileType, long modificationStamp) {
        this.myName = name2;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            LightVirtualFileBase.$$$reportNull$$$0(0);
        }
        return myVirtualFileSystem;
    }

    @Override
    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public String getPath() {
        VirtualFile parent2 = this.getParent();
        String string = (parent2 == null ? "" : parent2.getPath()) + "/" + this.getName();
        if (string == null) {
            LightVirtualFileBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LightVirtualFileBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean writable) {
        this.myIsWritable = writable;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            LightVirtualFileBase.$$$reportNull$$$0(3);
        }
        this.assertWritable();
        this.myName = newName;
    }

    void assertWritable() {
        if (!this.isWritable()) {
            throw new IncorrectOperationException("File is not writable: " + this);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(4);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildDirectory(requestor, name2);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            LightVirtualFileBase.$$$reportNull$$$0(6);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildData(requestor, name2);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @Override
    public void delete(Object requestor) throws IOException {
        this.assertWritable();
        super.delete(requestor);
    }

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            LightVirtualFileBase.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        super.move(requestor, newParent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long l2) throws IOException {
        void newTimeStamp;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(9);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(10);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "ksp/com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFileByPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshAndFindFileByPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

