/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.Function;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.Lists;
import ksp.com.google.common.collect.Ordering;
import ksp.com.google.common.collect.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SortedLists {
    private SortedLists() {
    }

    public static <E extends Comparable> int binarySearch(List<? extends E> list, E e2, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(e2);
        return SortedLists.binarySearch(list, e2, Ordering.natural(), presentBehavior, absentBehavior);
    }

    public static <E, K extends Comparable> int binarySearch(List<E> list, Function<? super E, K> keyFunction, K key, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(key);
        return SortedLists.binarySearch(list, keyFunction, key, Ordering.natural(), presentBehavior, absentBehavior);
    }

    public static <E, K> int binarySearch(List<E> list, Function<? super E, K> keyFunction, @ParametricNullness K key, Comparator<? super K> keyComparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        return SortedLists.binarySearch(Lists.transform(list, keyFunction), key, keyComparator, presentBehavior, absentBehavior);
    }

    public static <E> int binarySearch(List<? extends E> list, @ParametricNullness E key, Comparator<? super E> comparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(presentBehavior);
        Preconditions.checkNotNull(absentBehavior);
        if (!(list instanceof RandomAccess)) {
            list = Lists.newArrayList(list);
        }
        int lower2 = 0;
        int upper = list.size() - 1;
        while (lower2 <= upper) {
            int middle = lower2 + upper >>> 1;
            int c2 = comparator.compare(key, list.get(middle));
            if (c2 < 0) {
                upper = middle - 1;
                continue;
            }
            if (c2 > 0) {
                lower2 = middle + 1;
                continue;
            }
            return lower2 + presentBehavior.resultIndex(comparator, key, list.subList(lower2, upper + 1), middle - lower2);
        }
        return absentBehavior.resultIndex(lower2);
    }

    static enum KeyAbsentBehavior {
        NEXT_LOWER{

            @Override
            int resultIndex(int higherIndex) {
                return higherIndex - 1;
            }
        }
        ,
        NEXT_HIGHER{

            @Override
            public int resultIndex(int higherIndex) {
                return higherIndex;
            }
        }
        ,
        INVERTED_INSERTION_INDEX{

            @Override
            public int resultIndex(int higherIndex) {
                return ~higherIndex;
            }
        };


        abstract int resultIndex(int var1);
    }

    static enum KeyPresentBehavior {
        ANY_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return foundIndex;
            }
        }
        ,
        LAST_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower2 = foundIndex;
                int upper = list.size() - 1;
                while (lower2 < upper) {
                    int middle = lower2 + upper + 1 >>> 1;
                    int c2 = comparator.compare(list.get(middle), key);
                    if (c2 > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower2 = middle;
                }
                return lower2;
            }
        }
        ,
        FIRST_PRESENT{

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower2 = 0;
                int upper = foundIndex;
                while (lower2 < upper) {
                    int middle = lower2 + upper >>> 1;
                    int c2 = comparator.compare(list.get(middle), key);
                    if (c2 < 0) {
                        lower2 = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower2;
            }
        }
        ,
        FIRST_AFTER{

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return LAST_PRESENT.resultIndex(comparator, key, list, foundIndex) + 1;
            }
        }
        ,
        LAST_BEFORE{

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return FIRST_PRESENT.resultIndex(comparator, key, list, foundIndex) - 1;
            }
        };


        abstract <E> int resultIndex(Comparator<? super E> var1, @ParametricNullness E var2, List<? extends E> var3, int var4);
    }
}

