/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import ksp.com.github.benmanes.caffeine.cache.FWA;
import ksp.com.github.benmanes.caffeine.cache.Node;
import ksp.com.github.benmanes.caffeine.cache.UnsafeAccess;

class FWAR<K, V>
extends FWA<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(FWAR.class, "writeTime");
    volatile long writeTime;

    FWAR() {
    }

    FWAR(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    FWAR(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value2, valueReferenceQueue, weight, now);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FWAR<K, V>(key, keyReferenceQueue, value2, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value2, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FWAR<K, V>(keyReference, value2, valueReferenceQueue, weight, now);
    }
}

