/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.calls.checkers

import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.builtins.isBuiltinFunctionalType
import ksp.org.jetbrains.kotlin.builtins.isFunctionOrSuspendFunctionType
import ksp.org.jetbrains.kotlin.config.LanguageFeature
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor
import ksp.org.jetbrains.kotlin.diagnostics.Errors
import ksp.org.jetbrains.kotlin.diagnostics.reportDiagnosticOnce
import ksp.org.jetbrains.kotlin.diagnostics.reportDiagnosticOnceWrtDiagnosticFactoryList
import ksp.org.jetbrains.kotlin.psi.KtNameReferenceExpression
import ksp.org.jetbrains.kotlin.psi.KtParameter
import ksp.org.jetbrains.kotlin.resolve.BindingContext
import ksp.org.jetbrains.kotlin.resolve.calls.SPECIAL_FUNCTION_NAMES
import ksp.org.jetbrains.kotlin.resolve.calls.util.getParameterForArgument
import ksp.org.jetbrains.kotlin.resolve.calls.util.getResolvedCall
import ksp.org.jetbrains.kotlin.resolve.calls.model.*
import ksp.org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl
import ksp.org.jetbrains.kotlin.resolve.calls.tower.psiCallArgument
import ksp.org.jetbrains.kotlin.resolve.calls.tower.psiExpression
import ksp.org.jetbrains.kotlin.resolve.calls.tower.psiKotlinCall
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.isUnderscoreNamed
import ksp.org.jetbrains.kotlin.resolve.source.KotlinSourceElement
import ksp.org.jetbrains.kotlin.types.DeferredType
import ksp.org.jetbrains.kotlin.types.KotlinType
import ksp.org.jetbrains.kotlin.types.TypeUtils
import ksp.org.jetbrains.kotlin.types.typeUtil.isNothing
import ksp.org.jetbrains.kotlin.types.typeUtil.isNothingOrNullableNothing
import ksp.org.jetbrains.kotlin.types.typeUtil.isTypeParameter

object ReferencingToUnderscoreNamedParameterOfCatchBlockChecker : CallChecker {
    override fun check(resolvedCall: ResolvedCall<*>, reportOn: PsiElement, context: CallCheckerContext) {
        val descriptor = resolvedCall.resultingDescriptor

        if (descriptor !is LocalVariableDescriptor || !descriptor.isUnderscoreNamed) return

        val sourceElement = descriptor.source as? KotlinSourceElement ?: return
        val ktParameter = sourceElement.psi as? KtParameter ?: return

        if (ktParameter.isCatchParameter) {
            context.trace.reportDiagnosticOnce(Errors.RESOLVED_TO_UNDERSCORE_NAMED_CATCH_PARAMETER.on(reportOn))
        }
    }
}
