/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve

import ksp.org.jetbrains.kotlin.contracts.description.ContractProviderKey
import ksp.org.jetbrains.kotlin.contracts.description.LazyContractProvider
import ksp.org.jetbrains.kotlin.contracts.parsing.isContractCallDescriptor
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor
import ksp.org.jetbrains.kotlin.psi.Call
import ksp.org.jetbrains.kotlin.psi.KtExpression
import ksp.org.jetbrains.kotlin.psi.psiUtil.isContractDescriptionCallPsiCheck
import ksp.org.jetbrains.kotlin.psi.psiUtil.isFirstStatement
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope

/*
 * See KT-26386 and KT-30410
 */
fun disableContractsInsideContractsBlock(call: Call, descriptor: CallableDescriptor?, scope: LexicalScope, trace: BindingTrace) {
    (call.callElement as? KtExpression)?.let { callExpression ->
        if (callExpression.isFirstStatement() && callExpression.isContractDescriptionCallPsiCheck()) {
            if (descriptor?.isContractCallDescriptor() != true) {
                val functionDescriptor = scope.ownerDescriptor as? FunctionDescriptor
                val contractProvider = functionDescriptor?.getUserData(ContractProviderKey) as? LazyContractProvider
                contractProvider?.setContractDescription(null)
            } else {
                trace.record(BindingContext.IS_CONTRACT_DECLARATION_BLOCK, callExpression, true)
            }
        }
    }
}
