/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.kdoc.psi.impl;

import ksp.com.intellij.extapi.psi.ASTWrapperPsiElement;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage;
import ksp.org.jetbrains.kotlin.kdoc.psi.api.KDocElement;

public abstract class KDocElementImpl extends ASTWrapperPsiElement implements KDocElement {
    @NotNull
    @Override
    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @Override
    public String toString() {
        return getNode().getElementType().toString();
    }

    public KDocElementImpl(@NotNull ASTNode node) {
        super(node);
    }
}
