/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.interpreter.checker

import ksp.org.jetbrains.kotlin.ir.IrBuiltIns
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitor

abstract class IrInterpreterChecker : IrVisitor<Boolean, IrInterpreterCheckerData>()

class IrInterpreterCheckerData(
    val irFile: IrFile,
    val mode: EvaluationMode,
    val irBuiltIns: IrBuiltIns,
)
