/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.inline

import ksp.org.jetbrains.kotlin.backend.common.ModuleLoweringPass
import ksp.org.jetbrains.kotlin.backend.common.PreSerializationLoweringContext
import ksp.org.jetbrains.kotlin.backend.common.checkers.IrInlineDeclarationChecker
import ksp.org.jetbrains.kotlin.config.languageVersionSettings
import ksp.org.jetbrains.kotlin.diagnostics.impl.deduplicating
import ksp.org.jetbrains.kotlin.ir.IrDiagnosticReporter
import ksp.org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitor

class InlineDeclarationCheckerLowering<Context : PreSerializationLoweringContext>(val context: Context) : ModuleLoweringPass {
    override fun lower(irModule: IrModuleFragment) {
        val irDiagnosticReporter = KtDiagnosticReporterWithImplicitIrBasedContext(
            context.diagnosticReporter.deduplicating(),
            context.configuration.languageVersionSettings
        )

        irModule.runIrLevelCheckers(irDiagnosticReporter, ::IrInlineDeclarationChecker)
    }
}

fun IrModuleFragment.runIrLevelCheckers(
    diagnosticReporter: IrDiagnosticReporter,
    vararg checkers: (IrDiagnosticReporter) -> IrVisitor<*, Nothing?>,
) {
    for (checker in checkers) {
        accept(checker(diagnosticReporter), null)
    }
}
