/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.declarations.impl

import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor
import ksp.org.jetbrains.kotlin.ir.IrFileEntry
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment
import ksp.org.jetbrains.kotlin.ir.symbols.IrFileSymbol
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl
import ksp.org.jetbrains.kotlin.name.FqName

fun IrFileImpl(
    fileEntry: IrFileEntry,
    symbol: IrFileSymbol,
    fqName: FqName,
    module: IrModuleFragment,
) = IrFileImpl(fileEntry, symbol, fqName).apply {
    this.module = module
}

fun IrFileImpl(
    fileEntry: IrFileEntry,
    packageFragmentDescriptor: PackageFragmentDescriptor,
) = IrFileImpl(fileEntry, IrFileSymbolImpl(packageFragmentDescriptor), packageFragmentDescriptor.fqName)

fun IrFileImpl(
    fileEntry: IrFileEntry,
    packageFragmentDescriptor: PackageFragmentDescriptor,
    module: IrModuleFragment,
) = IrFileImpl(fileEntry, IrFileSymbolImpl(packageFragmentDescriptor), packageFragmentDescriptor.fqName, module)
