/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.lazy

import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase
import ksp.org.jetbrains.kotlin.fir.symbols.lazyResolveToPhase
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl
import ksp.org.jetbrains.kotlin.ir.declarations.lazy.IrLazyDeclarationBase
import ksp.org.jetbrains.kotlin.ir.declarations.lazy.lazyVar
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall
import kotlin.properties.ReadWriteProperty

interface AbstractFir2IrLazyDeclaration<F> :
    IrDeclaration, IrLazyDeclarationBase, Fir2IrComponents where F : FirDeclaration {

    val fir: F

    override val factory: IrFactory
        get() = IrFactoryImpl

    override fun createLazyAnnotations(): ReadWriteProperty<Any?, List<IrConstructorCall>> = lazyVar(lock) {
        // Normally lazy resolve would be not necessary here,
        // but in context of Kotlin project itself opened in IDE we can have here
        // an annotated built-in function in sources, like arrayOfNull (KT-70856).
        // For any other project, built-ins functions come from libraries and it's not actual.
        fir.lazyResolveToPhase(FirResolvePhase.ANNOTATION_ARGUMENTS)
        fir.annotations.mapNotNull {
            callGenerator.convertToIrConstructorCall(it) as? IrConstructorCall
        }
    }
}

internal fun mutationNotSupported(): Nothing =
    error("Mutation of Fir2Ir lazy elements is not possible")
