/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

package ksp.org.jetbrains.kotlin.fir.declarations

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.FirElement
import ksp.org.jetbrains.kotlin.fir.FirModuleData
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource

/**
 * Generated from: [org.jetbrains.kotlin.fir.tree.generator.FirTree.variable]
 */
sealed class FirVariable : FirCallableDeclaration(), FirStatement {
    abstract override val source: KtSourceElement?
    abstract override val moduleData: FirModuleData
    abstract override val origin: FirDeclarationOrigin
    abstract override val attributes: FirDeclarationAttributes
    abstract override val typeParameters: List<FirTypeParameterRef>
    abstract override val status: FirDeclarationStatus
    abstract override val returnTypeRef: FirTypeRef
    abstract override val receiverParameter: FirReceiverParameter?
    abstract override val deprecationsProvider: DeprecationsProvider
    abstract override val containerSource: DeserializedContainerSource?
    abstract override val dispatchReceiverType: ConeSimpleKotlinType?
    abstract override val contextParameters: List<FirValueParameter>
    abstract val name: Name
    abstract override val symbol: FirVariableSymbol<FirVariable>
    abstract val initializer: FirExpression?
    abstract val delegate: FirExpression?
    abstract val isVar: Boolean
    abstract val isVal: Boolean
    abstract val getter: FirPropertyAccessor?
    abstract val setter: FirPropertyAccessor?
    abstract val backingField: FirBackingField?
    abstract override val annotations: List<FirAnnotation>

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R =
        visitor.visitVariable(this, data)

    @Suppress("UNCHECKED_CAST")
    override fun <E : FirElement, D> transform(transformer: FirTransformer<D>, data: D): E =
        transformer.transformVariable(this, data) as E

    abstract override fun replaceStatus(newStatus: FirDeclarationStatus)

    abstract override fun replaceReturnTypeRef(newReturnTypeRef: FirTypeRef)

    abstract override fun replaceReceiverParameter(newReceiverParameter: FirReceiverParameter?)

    abstract override fun replaceDeprecationsProvider(newDeprecationsProvider: DeprecationsProvider)

    abstract override fun replaceContextParameters(newContextParameters: List<FirValueParameter>)

    abstract fun replaceInitializer(newInitializer: FirExpression?)

    abstract fun replaceDelegate(newDelegate: FirExpression?)

    abstract fun replaceGetter(newGetter: FirPropertyAccessor?)

    abstract fun replaceSetter(newSetter: FirPropertyAccessor?)

    abstract override fun replaceAnnotations(newAnnotations: List<FirAnnotation>)

    abstract override fun <D> transformTypeParameters(transformer: FirTransformer<D>, data: D): FirVariable

    abstract override fun <D> transformStatus(transformer: FirTransformer<D>, data: D): FirVariable

    abstract override fun <D> transformReturnTypeRef(transformer: FirTransformer<D>, data: D): FirVariable

    abstract override fun <D> transformReceiverParameter(transformer: FirTransformer<D>, data: D): FirVariable

    abstract override fun <D> transformContextParameters(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformInitializer(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformDelegate(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformGetter(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformSetter(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformBackingField(transformer: FirTransformer<D>, data: D): FirVariable

    abstract override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirVariable

    abstract fun <D> transformOtherChildren(transformer: FirTransformer<D>, data: D): FirVariable
}
