/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir

import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor

abstract class FirPureAbstractElement : FirElement {
    abstract override fun <R, D> acceptChildren(visitor: FirVisitor<R, D>, data: D)

    abstract override fun <D> transformChildren(transformer: FirTransformer<D>, data: D): FirElement
}