/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm.intrinsics

import ksp.org.jetbrains.kotlin.backend.jvm.codegen.*
import ksp.org.jetbrains.kotlin.backend.jvm.ir.unwrapInlineLambda
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression

object SingleArgumentInlineFunctionIntrinsic : IntrinsicMethod() {
    override fun invoke(expression: IrFunctionAccessExpression, codegen: ExpressionCodegen, data: BlockInfo): PromisedValue {
        val sourceCompiler =
            IrSourceCompilerForInline(codegen.state, expression, expression.symbol.owner, codegen, data, codegen.context.evaluatorData)
        val argumentExpression = expression.arguments[0]!!
        val inlineLambda = argumentExpression.unwrapInlineLambda()
        if (inlineLambda != null) {
            val lambdaInfo = IrExpressionLambdaImpl(codegen, inlineLambda)
            lambdaInfo.generateLambdaBody(sourceCompiler)
        }

        return codegen.unitValue
    }
}
