/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.common.checkers.type

import ksp.org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.ir.IrElement
import ksp.org.jetbrains.kotlin.ir.types.IrType

internal interface IrTypeChecker {
    fun check(type: IrType, container: IrElement, context: CheckerContext)
}

internal fun List<IrTypeChecker>.check(type: IrType, container: IrElement, context: CheckerContext) {
    for (checker in this) {
        checker.check(type, container, context)
    }
}
