/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.decompiler.psi

import ksp.com.intellij.openapi.vfs.VirtualFile
import ksp.com.intellij.psi.PsiManager
import ksp.com.intellij.psi.compiled.ClassFileDecompilers
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder.MultifileClassPartKindStrategy
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder

class KotlinClassFileDecompiler : ClassFileDecompilers.Full() {
    private val stubBuilder = KotlinClsStubBuilder()

    override fun accepts(file: VirtualFile) = ClsKotlinBinaryClassCache.getInstance().isKotlinJvmCompiledFile(file)

    override fun getStubBuilder() = stubBuilder

    override fun createFileViewProvider(file: VirtualFile, manager: PsiManager, physical: Boolean): KotlinDecompiledFileViewProvider {
        return KotlinDecompiledFileViewProvider(manager, file, physical) factory@{ provider ->
            val virtualFile = provider.virtualFile

            if (ClsClassFinder.isKotlinInternalCompiledFile(
                    file = virtualFile,
                    multifileClassPartKindStrategy = MultifileClassPartKindStrategy.NON_INTERNAL,
                )
            ) {
                null
            } else {
                KtClsFile(provider)
            }
        }
    }
}
