/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.projectStructure

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule

@KaImplementationDetail
class KaBaseModuleProvider(private val project: Project) : KaModuleProvider {
    override fun getModule(element: PsiElement, useSiteModule: KaModule?): KaModule =
        KotlinProjectStructureProvider.getModule(project, element, useSiteModule)
}
