/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.references

import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession
import ksp.org.jetbrains.kotlin.analysis.api.resolution.KaSimpleFunctionCall
import ksp.org.jetbrains.kotlin.analysis.api.resolution.calls
import ksp.org.jetbrains.kotlin.analysis.api.resolution.symbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbol
import ksp.org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference
import ksp.org.jetbrains.kotlin.psi.KtCallExpression
import ksp.org.jetbrains.kotlin.psi.KtImportAlias

internal class KaFirInvokeFunctionReference(expression: KtCallExpression) : KtInvokeFunctionReference(expression), KaFirReference {
    override fun KaFirSession.computeSymbols(): Collection<KaSymbol> {
        return expression.resolveToCall()?.calls.orEmpty().mapNotNull { call ->
            (call as? KaSimpleFunctionCall)
                ?.takeIf { it.isImplicitInvoke }
                ?.partiallyAppliedSymbol
                ?.symbol
                ?.takeUnless { it is KaNamedFunctionSymbol && it.isBuiltinFunctionInvoke }
        }
    }

    override fun isReferenceToImportAlias(alias: KtImportAlias): Boolean {
        return super<KaFirReference>.isReferenceToImportAlias(alias)
    }
}