// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util.messages.impl;

import ksp.com.intellij.util.messages.MessageBus;
import ksp.com.intellij.util.messages.MessageBusFactory;
import ksp.com.intellij.util.messages.MessageBusOwner;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MessageBusFactoryImpl extends MessageBusFactory {
  @Override
  public @NotNull MessageBus createMessageBus(@NotNull MessageBusOwner owner, @Nullable MessageBus parentBus) {
    if (parentBus == null) {
      return new RootBus(owner);
    }

    CompositeMessageBus parent = (CompositeMessageBus)parentBus;
    if (parent.getParent() == null) {
      return new CompositeMessageBus(owner, parent);
    }
    else {
      return new MessageBusImpl(owner, parent);
    }
  }

  public static @NotNull RootBus createRootBus(@NotNull MessageBusOwner owner) {
    return new RootBus(owner);
  }
}
