// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util.messages.impl

import ksp.com.intellij.openapi.extensions.PluginDescriptor
import ksp.com.intellij.util.messages.Topic
import ksp.com.intellij.util.messages.impl.MessageBusImpl.MessageHandlerHolder
import java.util.function.Predicate

internal class DescriptorBasedMessageBusConnection(@JvmField val module: PluginDescriptor,
                                                   @JvmField val topic: Topic<*>,
                                                   @JvmField val handlers: List<Any>) : MessageHandlerHolder {
  override fun collectHandlers(topic: Topic<*>, result: MutableList<in Any>) {
    if (this.topic === topic) {
      result.addAll(handlers)
    }
  }

  override fun disconnectIfNeeded(predicate: Predicate<Class<*>>) {
  }

  // never empty
  override val isDisposed: Boolean
    get() = false

  override fun toString(): String = "DescriptorBasedMessageBusConnection(handlers=$handlers)"
}