// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util.indexing;

import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.UserDataHolder;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;

public interface IndexedFile extends UserDataHolder {
  @NotNull FileType getFileType();

  @NotNull VirtualFile getFile();

  @NotNull String getFileName();

  Project getProject();
}
